/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.Duration;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class DurationStringValidator
implements IValidator<String> {
    @Override
    public IValidationResult validate(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return IValidationResult.valid();
        }
        try {
            Duration.parse(value);
            return IValidationResult.valid();
        }
        catch (Throwable exception) {
            return IValidationResult.inValid(exception.getLocalizedMessage());
        }
    }
}

