/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.time.ILocalDateTimeRange;
import net.anwiba.commons.utilities.time.LocalDateTimeUtilities;
import net.anwiba.commons.utilities.time.RelativeLocalDateTimeRange;

public final class LocalDateTimeRangeToStringConverter
implements IConverter<ILocalDateTimeRange, String, RuntimeException> {
    private final DateTimeFormatter formatter;

    public LocalDateTimeRangeToStringConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public String convert(ILocalDateTimeRange value) {
        if (value == null) {
            return null;
        }
        if (value instanceof RelativeLocalDateTimeRange) {
            RelativeLocalDateTimeRange timeRange = (RelativeLocalDateTimeRange)value;
            LocalDateTime from = LocalDateTimeUtilities.truncat(timeRange.getFrom(), timeRange.getDuration(), timeRange.getUnit());
            LocalDateTime until = from.plus(timeRange.getDuration());
            return this.formatter.format(from) + " - " + this.formatter.format(until);
        }
        return this.formatter.format(value.getFrom()) + " - " + this.formatter.format(value.getUntil());
    }
}

