/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import net.anwiba.commons.utilities.time.LocalDateTimeUtilities;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;

public class SystemDateTimeUtilities {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime atSystemZone(ZonedDateTime dateTime) {
        return LocalDateTimeUtilities.atZone(dateTime, ZonedDateTimeUtilities.getSystemZone());
    }

    public static LocalDateTime atUserZone(LocalDateTime localSystemDateTime) {
        return LocalDateTimeUtilities.atZone(localSystemDateTime, ZonedDateTimeUtilities.getSystemZone(), ZonedDateTimeUtilities.getUserZone());
    }

    public static LocalDateTime atCoordinatedUniversalTimeZone(LocalDateTime localSystemDateTime) {
        return LocalDateTimeUtilities.atZone(localSystemDateTime, ZonedDateTimeUtilities.getSystemZone(), ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static LocalDateTime fromCoordinatedUniversalTimeZone(LocalDateTime fromDate) {
        return LocalDateTimeUtilities.atZone(fromDate, ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone(), ZonedDateTimeUtilities.getSystemZone());
    }

    public static ZonedDateTime asZoneDateTime(LocalDateTime localSystemDateTime) {
        return localSystemDateTime.atZone(ZonedDateTimeUtilities.getSystemZone());
    }

    public static LocalDateTime atSystemZone(LocalDateTime localSystemDateTime, ZoneId sourceZone) {
        return LocalDateTimeUtilities.atZone(localSystemDateTime, sourceZone, ZonedDateTimeUtilities.getSystemZone());
    }

    public static LocalDateTime atSystemZone(java.sql.Date date) {
        return SystemDateTimeUtilities.atSystemZone(new Date(date.getTime()));
    }

    public static LocalDateTime atSystemZone(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZonedDateTimeUtilities.getSystemZone());
    }

    public static String toString(ZonedDateTime dateTime) {
        LocalDateTime userDateTime = SystemDateTimeUtilities.atSystemZone(dateTime);
        return userDateTime.atZone(ZonedDateTimeUtilities.getSystemZone()).format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static String toStringAtUserTimeZone(LocalDateTime systemDateTime) {
        LocalDateTime userDateTime = SystemDateTimeUtilities.atUserZone(systemDateTime);
        return userDateTime.atZone(ZonedDateTimeUtilities.getSystemZone()).format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }
}

