/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import net.anwiba.commons.utilities.time.IZonedDateTimeRange;
import net.anwiba.commons.utilities.time.LocalDateTimeSegment;
import net.anwiba.commons.utilities.time.LocalDateTimeUtilities;
import net.anwiba.commons.utilities.time.ZonedDateTimeRange;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;

public class UserDateTimeUtilities {
    public static IZonedDateTimeRange asZoneDateTimeRange(LocalDateTimeSegment userDateTimeSegment) {
        if (userDateTimeSegment == null) {
            return null;
        }
        ZonedDateTime time = UserDateTimeUtilities.asZoneDateTime(userDateTimeSegment.getTime());
        return new ZonedDateTimeRange(time, time.plus(userDateTimeSegment.getDuration(), userDateTimeSegment.getTimeUnit().toTemporalUnit()));
    }

    public static ZonedDateTime asZoneDateTime(LocalDateTime userDateTime) {
        return userDateTime.atZone(ZonedDateTimeUtilities.getUserZone());
    }

    public static LocalDateTime now() {
        return LocalDateTimeUtilities.atZone(ZonedDateTime.now(), ZonedDateTimeUtilities.getUserZone());
    }

    public static LocalDateTime atUserZone(ZonedDateTime dateTime) {
        return LocalDateTimeUtilities.atZone(dateTime, ZonedDateTimeUtilities.getUserZone());
    }

    public static LocalDateTime atSystemZone(LocalDateTime userDateTime) {
        return LocalDateTimeUtilities.atZone(userDateTime, ZonedDateTimeUtilities.getUserZone(), ZonedDateTimeUtilities.getSystemZone());
    }

    public static LocalDateTime atCoordinatedUniversalTimeZone(LocalDateTime userDateTime) {
        return LocalDateTimeUtilities.atZone(userDateTime, ZonedDateTimeUtilities.getUserZone(), ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static LocalDateTime atUserZone(LocalDateTime localSystemDateTime, ZoneId sourceZone) {
        return LocalDateTimeUtilities.atZone(localSystemDateTime, sourceZone, ZonedDateTimeUtilities.getUserZone());
    }

    public static LocalDateTime atUserZone(java.sql.Date date) {
        return UserDateTimeUtilities.atUserZone(new Date(date.getTime()));
    }

    public static LocalDateTime atUserZone(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZonedDateTimeUtilities.getUserZone());
    }

    public static String toString(LocalDateTime dateTime) {
        return dateTime.atZone(ZonedDateTimeUtilities.getUserZone()).format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static String toString(ZonedDateTime dateTime) {
        LocalDateTime userDateTime = UserDateTimeUtilities.atUserZone(dateTime);
        return userDateTime.atZone(ZonedDateTimeUtilities.getUserZone()).format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static String toStringAtSystemZone(LocalDateTime userDateTime) {
        LocalDateTime systemDateTime = UserDateTimeUtilities.atSystemZone(userDateTime);
        return systemDateTime.format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static LocalDateTime fromCoordinatedUniversalTimeZone(LocalDateTime fromDate) {
        return LocalDateTimeUtilities.atZone(fromDate, ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone(), ZonedDateTimeUtilities.getUserZone());
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(dateTime.toInstant(ZoneOffset.from(UserDateTimeUtilities.asZoneDateTime(dateTime))));
    }
}

