/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.validation;

import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.object.ObjectUtilities;

public interface IValidationResult {
    public static IValidationResult valid() {
        return new ValidationResult(true, null);
    }

    public static IValidationResult inValid(String message) {
        return new ValidationResult(false, message);
    }

    public boolean isValid();

    default public <E extends Exception> IValidationResult ifValid(IBlock<E> block) throws E {
        if (this.isValid()) {
            block.execute();
        }
        return this;
    }

    default public <E extends Exception> IValidationResult otherwise(IConsumer<String, E> consumer) throws E {
        if (!this.isValid()) {
            consumer.consume((Object)this.getMessage());
        }
        return this;
    }

    public String getMessage();

    public static final class ValidationResult
    implements IValidationResult {
        private final String message;
        private final boolean isValid;

        public ValidationResult(boolean isValid, String message) {
            this.isValid = isValid;
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            return ObjectUtilities.hashCode((Object[])new Object[]{this.isValid, this.message});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IValidationResult)) {
                return false;
            }
            IValidationResult other = (IValidationResult)obj;
            return this.isValid != other.isValid() && ObjectUtilities.equals((Object)this.message, (Object)other.getMessage());
        }
    }
}

