/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.DoubleArrays;

public class ArrayUtilities {
    public static int getMin(int[] values) {
        int result = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= result) continue;
            result = value;
        }
        return result;
    }

    public static int getMax(int[] values) {
        int result = Integer.MAX_VALUE;
        for (int value : values) {
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    public static double getMin(double[] values) {
        double result = Double.POSITIVE_INFINITY;
        for (double value : values) {
            if (Double.isNaN(value) || !(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static double getMax(double[] values) {
        double result = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            if (Double.isNaN(value) || !(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static byte[] concat(byte[] values0, byte[] values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        return ArrayUtilities.concat(values0, values1, values1.length);
    }

    public static byte[] concat(byte[] values0, byte[] values1, int length) {
        byte[] result = new byte[values0.length + length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, length);
        return result;
    }

    public static byte[] copy(byte[] values1) {
        byte[] result = new byte[values1.length];
        System.arraycopy(values1, 0, result, 0, values1.length);
        return result;
    }

    public static int[] concat(int[] values0, int ... values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        int[] result = new int[values0.length + values1.length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, values1.length);
        return result;
    }

    public static int[] copy(int[] values) {
        int[] result = new int[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static double[] concat(double[] values0, double[] values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        double[] result = new double[values0.length + values1.length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, values1.length);
        return result;
    }

    public static double[] copy(double[] values) {
        return DoubleArrays.copy(values);
    }

    public static <T> T[] copy(T[] array) {
        return ArrayUtilities.copy(array.getClass().getComponentType(), array);
    }

    public static <O, T extends O> O[] copy(Class<O> clazz, T[] array) {
        if (array == null) {
            return array;
        }
        O[] target = ArrayUtilities.create(clazz, array.length);
        System.arraycopy(array, 0, target, 0, array.length);
        return target;
    }

    public static <O, T extends O> O[] concat(Class<O> clazz, T[] array1, T ... array2) {
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        if (array1 == null || array1.length == 0) {
            return array2;
        }
        O[] mergedArray = ArrayUtilities.create(clazz, array1.length + array2.length);
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public static <O, T extends O> O[] concat(Class<O> clazz, T object, T ... array) {
        O[] objects = ArrayUtilities.asArray(clazz, object);
        return ArrayUtilities.concat(clazz, objects, array);
    }

    public static <O, T extends O> O[] asArray(Class<O> clazz, T object) {
        O[] array = ArrayUtilities.create(clazz, 1);
        array[0] = object;
        return array;
    }

    public static double[] reverse(double[] values) {
        int n = values.length;
        double[] reverse = new double[n];
        for (int i = 0; i < n; ++i) {
            reverse[n - 1 - i] = values[i];
        }
        return reverse;
    }

    public static boolean allValuesNaN(double[] values) {
        for (double value : values) {
            if (Double.isNaN(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[] values, int value) {
        for (int i : values) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    public static <I, O, E extends Exception> O[] convert(IConverter<I, O, E> converter, I[] values, Class<O> clazz) throws E {
        ArrayList<Object> list = new ArrayList<Object>();
        for (I value : values) {
            Object result = converter.convert(value);
            if (result == null) continue;
            list.add(result);
        }
        int length = values.length;
        O[] array = ArrayUtilities.create(clazz, length);
        return list.toArray(array);
    }

    public static <C> boolean instanceOf(Object[] objects, Class<C> clazz) {
        for (Object object : objects) {
            if (clazz.isInstance(object)) continue;
            return false;
        }
        return true;
    }

    public static <O, T extends O> O[] remove(O[] source, T value, Class<O> clazz) {
        ArrayList<O> list = new ArrayList<O>();
        for (O item : source) {
            if (ObjectUtilities.equals(value, item)) continue;
            list.add(item);
        }
        return ArrayUtilities.toArray(clazz, list);
    }

    private static <O, T extends O> O[] toArray(Class<O> clazz, List<T> list) {
        O[] target = ArrayUtilities.create(clazz, list.size());
        for (int i = 0; i < target.length; ++i) {
            target[i] = list.get(i);
        }
        return target;
    }

    public static <T> T[] filter(T[] array, IAcceptor<T> validator) {
        return ArrayUtilities.filter(array.getClass().getComponentType(), array, validator);
    }

    public static <O, T extends O> O[] filter(Class<O> clazz, T[] array, IAcceptor<O> validator) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : array) {
            if (!validator.accept(item)) continue;
            list.add(item);
        }
        return ArrayUtilities.toArray(clazz, list);
    }

    public static <T> T findFirst(T[] values, IAcceptor<T> validator) {
        for (T value : values) {
            if (!validator.accept(value)) continue;
            return value;
        }
        return null;
    }

    public static int[] primitives(Integer[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] primitives(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] primitives(Byte[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static <T> int indexOf(T[] objects, IAcceptor<T> validator) {
        for (int index = 0; index < objects.length; ++index) {
            if (!validator.accept(objects[index])) continue;
            return index;
        }
        return -1;
    }

    public static Short[] objects(short[] array) {
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Integer[] objects(int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] objects(long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] objects(float[] array) {
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] objects(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] objects(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] objects(char[] array) {
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Boolean[] objects(boolean[] array) {
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static <T> T[] create(T ... objects) {
        return objects;
    }

    public static <T> T[] normalize(T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (T t : values) {
            if (t == null) continue;
            list.add(t);
        }
        return ArrayUtilities.toArray(values.getClass().getComponentType(), list);
    }

    public static <T> T[] create(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    public static <T> boolean contains(T[] array, T object) {
        for (T item : array) {
            if (!ObjectUtilities.equals(item, object)) continue;
            return true;
        }
        return false;
    }
}

