/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

public class OperationSystemUtilities {
    private static final String OPERATION_SYSTEM = System.getProperty("os.name");
    private static final String BSD = "BSD";
    private static final String UNIX = "UNIX";
    private static final String MAC = "MAC";
    private static final String WINDOW = "WINDOW";
    private static final String LINUX = "LINUX";

    public static boolean isLinux() {
        return OperationSystemUtilities.validate(LINUX);
    }

    public static boolean isWindows() {
        return OperationSystemUtilities.validate(WINDOW);
    }

    public static boolean isMac() {
        return OperationSystemUtilities.validate(MAC);
    }

    public static boolean isBSD() {
        return OperationSystemUtilities.validate(BSD);
    }

    public static boolean isUnix() {
        return OperationSystemUtilities.isLinux() || OperationSystemUtilities.isMac() || OperationSystemUtilities.isBSD() || OperationSystemUtilities.validate(UNIX);
    }

    public static String getOperationSystemName() {
        return OPERATION_SYSTEM;
    }

    private static boolean validate(String name) {
        String osName = OperationSystemUtilities.getOperationSystemName();
        return osName.toUpperCase().contains(name);
    }
}

