/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.collection;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IEqualComperator;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class ListUtilities {
    public static <T> List<T> normalize(Iterable<T> iterable) {
        return new ArrayList<T>(IterableUtilities.asSet(iterable));
    }

    public static <T> List<T> getContainsNot(final List<T> list, final Iterable<T> other) {
        return IterableUtilities.asList(other, new IAcceptor<T>(){

            public boolean accept(T value) {
                return !list.contains(other);
            }
        });
    }

    public static boolean equals(List<?> objects, List<?> others) {
        if (objects == others) {
            return true;
        }
        if (objects == null || others == null || objects.size() != others.size()) {
            return false;
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (ObjectUtilities.equals(objects.get(i), others.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> filter(Iterable<T> values, IAcceptor<T> validator) {
        ArrayList<T> result = new ArrayList<T>();
        for (T value : values) {
            if (!validator.accept(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static <T> int[] indices(List<T> list, Iterable<T> values, IEqualComperator<T> comperator) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (T value : values) {
            for (int i = 0; i < list.size(); ++i) {
                Integer index = i;
                if (!comperator.equals(value, list.get(i)) || result.contains(index)) continue;
                result.add(index);
            }
        }
        return ArrayUtilities.primitives(result.toArray(new Integer[result.size()]));
    }

    public static <I, O, E extends Exception> List<O> convert(Iterable<I> values, IConverter<I, O, E> converter) throws E {
        ArrayList<Object> result = new ArrayList<Object>();
        for (I value : values) {
            result.add(converter.convert(value));
        }
        return result;
    }

    public static <I> List<I> concat(Iterable<I> ... values) {
        ArrayList<I> result = new ArrayList<I>();
        for (Iterable<I> value : values) {
            for (I item : value) {
                result.add(item);
            }
        }
        return result;
    }
}

