/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import java.util.Objects;
import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.DirectionOrientation;

public class DirectionAngle {
    private final Angle angle;
    private final DirectionOrientation orientation;

    public static DirectionAngle of(Angle angle, DirectionOrientation orientation) {
        return new DirectionAngle(angle, orientation);
    }

    public static DirectionAngle radian(double value, DirectionOrientation orientation) {
        return DirectionAngle.of(Angle.radian(value), orientation);
    }

    public static DirectionAngle degree(double value, DirectionOrientation orientation) {
        return DirectionAngle.of(Angle.degree(value), orientation);
    }

    public static DirectionAngle gon(double value, DirectionOrientation orientation) {
        return DirectionAngle.of(Angle.gon(value), orientation);
    }

    private DirectionAngle(Angle angle, DirectionOrientation orientation) {
        this.angle = angle.modulo();
        this.orientation = orientation;
    }

    public Angle getAngle() {
        return this.angle;
    }

    public DirectionOrientation getOrientation() {
        return this.orientation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.angle, this.orientation});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionAngle other = (DirectionAngle)obj;
        return Objects.equals(this.angle, other.angle) && this.orientation == other.orientation;
    }

    public double radian() {
        return this.angle.radian();
    }

    public double degree() {
        return this.angle.degree();
    }

    public double gon() {
        return this.angle.gon();
    }

    public DirectionAngle nonNegativ() {
        return DirectionAngle.of(this.angle.moduloPositive(), this.orientation);
    }

    public DirectionAngle add(Angle angle) {
        return DirectionAngle.of(angle.add(angle), this.orientation);
    }

    public DirectionAngle subtract(Angle angle) {
        return DirectionAngle.of(angle.subtract(angle), this.orientation);
    }

    public DirectionAngle toMath() {
        return DirectionOrientation.convertTo(this, DirectionOrientation.MATH);
    }

    public DirectionAngle toGeograpic() {
        return DirectionOrientation.convertTo(this, DirectionOrientation.GEOGRAPHIC_NORTH);
    }

    public DirectionAngle convertTo(DirectionOrientation orientation) {
        return DirectionOrientation.convertTo(this, orientation);
    }

    public DirectionAngle addClockwise(Angle angle) {
        return DirectionOrientation.addClockwise(this, angle);
    }

    public DirectionAngle subtractClockwise(Angle angle) {
        return DirectionOrientation.subtractClockwise(this, angle);
    }
}

