/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;
import net.anwiba.commons.utilities.property.PropertiesBuilder;

public final class Properties
implements IProperties {
    private final Map<String, IProperty> map = new LinkedHashMap<String, IProperty>();

    public static IProperties empty() {
        return Properties.builder().build();
    }

    public static PropertiesBuilder builder() {
        return new PropertiesBuilder();
    }

    public static PropertiesBuilder builder(IProperties properties) {
        return new PropertiesBuilder(properties);
    }

    public Properties(List<IProperty> properties) {
        Streams.of(properties).filter(property -> property.getName() != null).foreach(property -> this.map.put(property.getName(), (IProperty)property));
    }

    @Override
    public Iterable<IProperty> properties() {
        return this.map.values();
    }

    @Override
    public Iterable<String> getNames() {
        return this.map.keySet();
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return this.map.equals(other.map);
    }

    @Override
    public String getValueOrDefault(String name, String defaultValue) {
        if (!this.map.containsKey(name)) {
            return defaultValue;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

