/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.regex.tokenizer;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpUtilities {
    public static String replace(Pattern pattern, String value, Collection<String> names) {
        int length = value.length();
        Replacement replacement = new Replacement(length, length, value);
        while ((replacement = RegExpUtilities.replace(pattern, replacement.value(), replacement.start(), names)).start() > 0) {
        }
        return replacement.value();
    }

    private static Replacement replace(Pattern pattern, String value, int until, Collection<String> names) {
        Matcher matcher = pattern.matcher(value.substring(0, until));
        if (!matcher.find() || matcher.groupCount() == 0) {
            return new Replacement(-1, -1, value);
        }
        LinkedList<Replacement> replacements = new LinkedList<Replacement>();
        for (String name : names) {
            int start = matcher.start(name);
            int end = matcher.end(name);
            if (start <= -1) continue;
            replacements.add(new Replacement(start, end, name));
        }
        if (replacements.isEmpty()) {
            return new Replacement(-1, -1, value);
        }
        Collections.sort(replacements, Comparator.comparing(object -> object.start()));
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        for (Replacement replacement : replacements) {
            if (replacement.start() > pos) {
                builder.append(value.substring(pos, replacement.start()));
            }
            builder.append("${");
            builder.append(replacement.value());
            builder.append("}");
            pos = replacement.end();
        }
        if (pos < value.length()) {
            builder.append(value.substring(pos));
        }
        String string = builder.toString();
        return new Replacement(((Replacement)replacements.iterator().next()).start(), string.length(), string);
    }

    public static String replace(Pattern pattern, String group, String value, IntFunction<String> valueFactory) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        Replacement replacement = new Replacement(length, length, value);
        while ((replacement = RegExpUtilities.replace(pattern, group, replacement.value(), replacement.start(), valueFactory)).start() > 0) {
        }
        return replacement.value();
    }

    private static Replacement replace(Pattern pattern, String group, String value, int until, IntFunction<String> valueFactory) {
        Matcher matcher = pattern.matcher(value.substring(0, until));
        int start = 0;
        if (!matcher.find() || matcher.groupCount() == 0 || (start = matcher.start(group)) < 0) {
            return new Replacement(-1, -1, value);
        }
        StringBuilder builder = new StringBuilder();
        if (start > 0) {
            builder.append(value.substring(0, start));
        }
        int end = matcher.end(group);
        builder.append(valueFactory.apply(end - start));
        if (end < value.length()) {
            builder.append(value.substring(end));
        }
        String string = builder.toString();
        return new Replacement(start, string.length(), string);
    }

    public static String[] getGroups(Matcher matcher) {
        String[] groups = new String[matcher.groupCount() + 1];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = matcher.group(i);
        }
        return groups;
    }

    public static boolean like(String valueString, String likeString, char escapeCharacter) {
        Pattern pattern = RegExpUtilities.createLikePattern(likeString, escapeCharacter);
        Matcher matcher = pattern.matcher(valueString);
        return matcher.matches();
    }

    public static Pattern createLikePattern(String likeString, char escapeCharacter) {
        String regExp = RegExpUtilities.createRegularExpressionString(likeString, escapeCharacter);
        Pattern pattern = Pattern.compile(regExp);
        return pattern;
    }

    /*
     * Unable to fully structure code
     */
    public static String createRegularExpressionString(String likeString, char escapeCharacter) {
        builder = new StringBuilder();
        isEscaped = false;
        block24: for (char c : likeString.toCharArray()) {
            if (c == escapeCharacter && !isEscaped) {
                isEscaped = true;
                continue;
            }
            if (!isEscaped) ** GOTO lbl-1000
            switch (c) {
                case '%': {
                    builder.append('%');
                    continue block24;
                }
                case '_': {
                    builder.append('_');
                    isEscaped = false;
                    continue block24;
                }
                default: lbl-1000:
                // 2 sources

                {
                    isEscaped = false;
                    switch (c) {
                        case '\\': {
                            builder.append("\\\\");
                            isEscaped = false;
                            continue block24;
                        }
                        case '[': {
                            builder.append("\\[");
                            isEscaped = false;
                            continue block24;
                        }
                        case ']': {
                            builder.append("\\]");
                            isEscaped = false;
                            continue block24;
                        }
                        case '{': {
                            builder.append("\\{");
                            isEscaped = false;
                            continue block24;
                        }
                        case '}': {
                            builder.append("\\}");
                            isEscaped = false;
                            continue block24;
                        }
                        case '(': {
                            builder.append("\\(");
                            isEscaped = false;
                            continue block24;
                        }
                        case ')': {
                            builder.append("\\)");
                            isEscaped = false;
                            continue block24;
                        }
                        case '.': {
                            builder.append("\\.");
                            isEscaped = false;
                            continue block24;
                        }
                        case '^': {
                            builder.append("\\^");
                            isEscaped = false;
                            continue block24;
                        }
                        case '$': {
                            builder.append("\\$");
                            isEscaped = false;
                            continue block24;
                        }
                        case '?': {
                            builder.append("\\?");
                            isEscaped = false;
                            continue block24;
                        }
                        case '*': {
                            builder.append("\\*");
                            isEscaped = false;
                            continue block24;
                        }
                        case '+': {
                            builder.append("\\+");
                            isEscaped = false;
                            continue block24;
                        }
                        case '|': {
                            builder.append("\\|");
                            isEscaped = false;
                            continue block24;
                        }
                        case '-': {
                            builder.append("\\-");
                            isEscaped = false;
                            continue block24;
                        }
                        case '&': {
                            builder.append("\\&");
                            isEscaped = false;
                            continue block24;
                        }
                        case '%': {
                            builder.append("(.)*");
                            isEscaped = false;
                            continue block24;
                        }
                        case '_': {
                            builder.append('.');
                            continue block24;
                        }
                    }
                    builder.append(c);
                    continue block24;
                }
            }
        }
        return builder.toString();
    }

    private record Replacement(int start, int end, String value) {
    }
}

