/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.provider.IContextValueProvider;
import net.anwiba.commons.utilities.string.AbstractStringResolver;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class DateStringResolver
extends AbstractStringResolver {
    public DateStringResolver(IStringAppender stringAppender) {
        super(stringAppender, (IConverter<String, String, ConversionException>)((IConverter)value -> value), DATE_PATTERN, new IContextValueProvider<String, String, RuntimeException>(){

            @Override
            public String getValue(String name) throws RuntimeException {
                try {
                    return UserDateTimeUtilities.now().format(DateTimeFormatter.ofPattern(name));
                }
                catch (DateTimeException exception) {
                    return name;
                }
            }
        });
    }
}

