/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import net.anwiba.commons.lang.collection.CollectionAcceptorBuilder;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.utilities.string.StringUtilities;

public class StringCollectionAcceptorBuilder
extends CollectionAcceptorBuilder<String> {
    private boolean ignoreCase = false;

    public StringCollectionAcceptorBuilder ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public StringCollectionAcceptorBuilder caseSensitive() {
        this.ignoreCase = false;
        return this;
    }

    public StringCollectionAcceptorBuilder accept(String ... values) {
        return this.accept(value -> this.ignoreCase ? StringUtilities.containsIgnoreCase(value, values) : StringUtilities.contains(value, values));
    }

    public StringCollectionAcceptorBuilder accept(IAcceptor<String> acceptor) {
        super.accept(acceptor);
        return this;
    }

    public StringCollectionAcceptorBuilder otherwise(IAcceptor<String> otherwise) {
        super.otherwise(otherwise);
        return this;
    }

    public StringCollectionAcceptorBuilder otherwise(String ... values) {
        return this.otherwise(value -> this.ignoreCase ? StringUtilities.containsIgnoreCase(value, values) : StringUtilities.contains(value, values));
    }
}

