/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.provider.INamedValueProvider;
import net.anwiba.commons.utilities.regex.tokenizer.RegExpUtilities;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.IStringResolver;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringResolver;

public class StringResolverBuilder {
    private final HashMap<String, String> map = new LinkedHashMap<String, String>();
    private IStringAppender errorHandler = new StringAppender();
    private Pattern pattern = IStringResolver.PLACEHOLDER_PATTERN;
    private Pattern converterPattern = null;

    public StringResolverBuilder errorHandler(IStringAppender errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public StringResolverBuilder converterPattern(String converterPattern) {
        return this.converterPattern(Pattern.compile(converterPattern));
    }

    public StringResolverBuilder converterPattern(Pattern converterPattern) {
        this.converterPattern = converterPattern;
        return this;
    }

    public StringResolverBuilder pattern(String pattern) {
        return this.pattern(Pattern.compile(pattern));
    }

    public StringResolverBuilder pattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public StringResolverBuilder optional(String name, String value) {
        this.map.put(name, value);
        return this;
    }

    public StringResolverBuilder add(String name, String value) {
        Ensure.ensureArgumentNotNull((Object)name);
        Ensure.ensureArgumentNotNull((Object)value);
        return this.optional(name, value);
    }

    public IStringResolver build() {
        IConverter valueConverter = this.converterPattern == null ? value -> value : value -> RegExpUtilities.replace(this.converterPattern, value, this.map.keySet());
        return new StringResolver(this.errorHandler, (IConverter<String, String, ConversionException>)valueConverter, new INamedValueProvider<String, RuntimeException>(){

            @Override
            public String getValue(String name) throws RuntimeException {
                return StringResolverBuilder.this.map.get(name);
            }

            @Override
            public Iterable<String> getNames() {
                return StringResolverBuilder.this.map.keySet();
            }
        }, this.pattern);
    }
}

