/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import net.anwiba.commons.utilities.time.ILocalDateTimeRange;
import net.anwiba.commons.utilities.time.RelativeLocalDateTimeRange;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class LocalDateTimeRange
implements ILocalDateTimeRange {
    private static final long serialVersionUID = 1L;
    private final LocalDateTime from;
    private final LocalDateTime until;

    public LocalDateTimeRange(LocalDateTime from, LocalDateTime until) {
        this.from = from;
        this.until = until;
    }

    @Override
    public LocalDateTime getFrom() {
        return this.from;
    }

    @Override
    public LocalDateTime getUntil() {
        return this.until;
    }

    @Override
    public LocalDateTime getCenter() {
        return this.from.plus(this.getDuration().dividedBy(2L));
    }

    @Override
    public Duration getDuration() {
        return Duration.between(this.from, this.until);
    }

    @Override
    public boolean interact(LocalDateTime time) {
        if (time == null) {
            return false;
        }
        return (this.from.isBefore(time) || this.from.isEqual(time)) && this.getUntil().isAfter(time);
    }

    @Override
    public boolean interact(ILocalDateTimeRange segment) {
        if (segment == null) {
            return false;
        }
        if (segment.getUntil().equals(this.getFrom()) || segment.getUntil().isBefore(this.getFrom())) {
            return false;
        }
        return !segment.getFrom().equals(this.getUntil()) && !segment.getFrom().isAfter(this.getUntil());
    }

    @Override
    public ILocalDateTimeRange intersection(ILocalDateTimeRange segment) {
        if (!this.interact(segment)) {
            return null;
        }
        LocalDateTime from = segment.getFrom().isAfter(this.getFrom()) ? segment.getFrom() : this.getFrom();
        LocalDateTime until = segment.getUntil().isBefore(this.getUntil()) ? segment.getUntil() : this.getUntil();
        return new LocalDateTimeRange(from, until);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.until);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalDateTimeRange)) {
            return false;
        }
        LocalDateTimeRange other = (LocalDateTimeRange)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.until, other.until);
    }

    @Override
    public Duration getDurationFromUntilToNow() {
        LocalDateTime now = this.now();
        if (now.isBefore(this.until)) {
            return Duration.between(now, this.until);
        }
        return Duration.between(this.until, now);
    }

    private LocalDateTime now() {
        return UserDateTimeUtilities.now().toLocalDateTime();
    }

    @Override
    public Duration getDurationFromFromToNow() {
        LocalDateTime now = this.now();
        if (now.isBefore(this.from)) {
            return Duration.between(now, this.from);
        }
        return Duration.between(this.from, now);
    }

    @Override
    public ILocalDateTimeRange shift(long value, TemporalUnit unit) {
        return new LocalDateTimeRange(this.from.plus(value, unit), this.until.plus(value, unit));
    }

    @Override
    public ILocalDateTimeRange duration(long value, TemporalUnit unit) {
        LocalDateTime result = this.from.plus(value, unit);
        if (result.isBefore(this.from)) {
            return new LocalDateTimeRange(this.from, this.from.plus(1L, ChronoUnit.SECONDS));
        }
        return new LocalDateTimeRange(this.from, result);
    }

    @Override
    public ILocalDateTimeRange plus(long value, TemporalUnit unit) {
        return new LocalDateTimeRange(this.from, this.until.plus(value, unit));
    }

    @Override
    public ILocalDateTimeRange minus(long value, TemporalUnit unit) {
        LocalDateTime result = this.until.minus(value, unit);
        if (result.isBefore(this.from)) {
            return new LocalDateTimeRange(this.from, this.from.plus(1L, ChronoUnit.SECONDS));
        }
        return new LocalDateTimeRange(this.from, result);
    }

    @Override
    public ILocalDateTimeRange toRelative() {
        return RelativeLocalDateTimeRange.of((TemporalAmount)this.getDurationFromFromToNow(), this.getDurationFromUntilToNow(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    @Override
    public ILocalDateTimeRange toAbsolute() {
        return new LocalDateTimeRange(this.from, this.until);
    }

    @Override
    public ILocalDateTimeRange toRelative(TemporalUnit unit) {
        return this.toRelative().toRelative(unit);
    }
}

