/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.format.DateTimeFormatter;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class LocalDateTimeRangeStringValidator
implements IValidator<String> {
    private final DateTimeFormatter formatter;

    public LocalDateTimeRangeStringValidator(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public IValidationResult validate(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return IValidationResult.valid();
        }
        try {
            String[] strings = value.split(" - ");
            if (strings.length != 2) {
                return IValidationResult.inValid("invalid value");
            }
            this.formatter.parse(strings[0]);
            this.formatter.parse(strings[1]);
            return IValidationResult.valid();
        }
        catch (Throwable exception) {
            return IValidationResult.inValid(exception.getLocalizedMessage());
        }
    }
}

