/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class StringToLocalDateConverter
implements IConverter<String, LocalDate, RuntimeException> {
    private final DateTimeFormatter formatter;

    public StringToLocalDateConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public LocalDate convert(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return null;
        }
        try {
            return LocalDate.from(this.formatter.parse(value));
        }
        catch (DateTimeParseException exception) {
            return null;
        }
    }
}

