/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class StringToLocalDateTimeConverter
implements IConverter<String, LocalDateTime, RuntimeException> {
    private final DateTimeFormatter formatter;

    public StringToLocalDateTimeConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public LocalDateTime convert(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return null;
        }
        try {
            return LocalDateTime.from(this.formatter.parse(value));
        }
        catch (DateTimeParseException exception) {
            return null;
        }
    }
}

