/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class StringToLocalTimeConverter
implements IConverter<String, LocalTime, RuntimeException> {
    private final DateTimeFormatter formatter;

    public StringToLocalTimeConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public LocalTime convert(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return null;
        }
        try {
            return LocalTime.from(this.formatter.parse(value));
        }
        catch (DateTimeParseException exception) {
            return null;
        }
    }
}

