/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class StringToZonedDateTimeConverter
implements IConverter<String, ZonedDateTime, RuntimeException> {
    private final DateTimeFormatter formatter;

    public StringToZonedDateTimeConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public ZonedDateTime convert(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return null;
        }
        try {
            return ZonedDateTime.of(LocalDateTime.from(this.formatter.parse(value)), ZoneId.systemDefault());
        }
        catch (DateTimeParseException exception) {
            return null;
        }
    }
}

