/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import net.anwiba.commons.utilities.time.LocalDateTimeUtilities;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class TemporalAmountUtilities {
    public static final LocalDateTime ZERO_DATE_TIME = LocalDateTimeUtilities.ZERO_DATE_TIME;

    public static Duration duration(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDateTime time = TemporalAmountUtilities.time(year, month, dayOfMonth, hour, minute, second);
        return Duration.between(ZERO_DATE_TIME, time);
    }

    public static Duration duration(TemporalAmount value) {
        LocalDateTime time = TemporalAmountUtilities.toDateTime(value);
        return Duration.between(ZERO_DATE_TIME, time);
    }

    public static Period period(TemporalAmount value) {
        LocalDateTime time = TemporalAmountUtilities.toDateTime(value);
        return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
    }

    public static TemporalAmount temporalAmount(Duration duration, TemporalUnit temporalUnit) {
        if (temporalUnit.isDateBased()) {
            return TemporalAmountUtilities.period(duration);
        }
        return duration;
    }

    public static Duration mod(TemporalAmount value) {
        LocalDateTime time = TemporalAmountUtilities.toDateTime(value);
        return Duration.between(ZERO_DATE_TIME.toLocalTime(), time.toLocalTime());
    }

    public static Period period(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDateTime time = TemporalAmountUtilities.time(year, month, dayOfMonth, hour, minute, second);
        return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
    }

    private static LocalDateTime time(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
    }

    public static TemporalAmount plus(TemporalAmount value, long count, TemporalUnit unit) {
        LocalDateTime dateTime = TemporalAmountUtilities.toDateTime(value).plus(count, unit);
        if (unit.isDateBased()) {
            return TemporalAmountUtilities.toPeriod(dateTime);
        }
        return TemporalAmountUtilities.toDuration(dateTime);
    }

    public static TemporalAmount minus(TemporalAmount value, long count, TemporalUnit unit) {
        LocalDateTime dateTime = TemporalAmountUtilities.toDateTime(value).minus(count, unit);
        if (unit.isDateBased()) {
            return TemporalAmountUtilities.toPeriod(dateTime);
        }
        return TemporalAmountUtilities.toDuration(dateTime);
    }

    public static TemporalAmount round(TemporalAmount value, TemporalUnit unit) {
        TemporalAmount floor = TemporalAmountUtilities.floor(value, unit);
        TemporalAmount ceil = TemporalAmountUtilities.plus(floor, 1L, unit);
        if (TemporalAmountUtilities.duration(value).minus(TemporalAmountUtilities.duration(floor)).compareTo(TemporalAmountUtilities.duration(ceil).minus(TemporalAmountUtilities.duration(value))) > 0) {
            return ceil;
        }
        return floor;
    }

    public static TemporalAmount ceil(TemporalAmount value, TemporalUnit unit) {
        return TemporalAmountUtilities.plus(TemporalAmountUtilities.floor(value, unit), 1L, unit);
    }

    public static TemporalAmount floor(TemporalAmount value, TemporalUnit unit) {
        LocalDateTime time = TemporalAmountUtilities.floor(TemporalAmountUtilities.toDateTime(value), unit);
        if (ChronoUnit.SECONDS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Duration.between(ZERO_DATE_TIME, time);
        }
        if (ChronoUnit.MINUTES.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Duration.between(ZERO_DATE_TIME, time);
        }
        if (ChronoUnit.HOURS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Duration.between(ZERO_DATE_TIME, time);
        }
        if (ChronoUnit.DAYS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
        }
        if (ChronoUnit.MONTHS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
        }
        if (ChronoUnit.YEARS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
        }
        return Period.between(ZERO_DATE_TIME.toLocalDate(), time.toLocalDate());
    }

    public static LocalDateTime floor(LocalDateTime time, TemporalUnit unit) {
        LocalDateTime value = time.withNano(0);
        if (ChronoUnit.SECONDS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withSecond(0);
        if (ChronoUnit.MINUTES.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withMinute(0);
        if (ChronoUnit.HOURS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withHour(0);
        if (ChronoUnit.DAYS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withDayOfMonth(1);
        if (ChronoUnit.MONTHS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withMonth(1);
        if (ChronoUnit.YEARS.getDuration().compareTo(unit.getDuration()) >= 0) {
            return value;
        }
        value = value.withYear(0);
        return value;
    }

    public static LocalDateTime toDateTime(TemporalAmount value) {
        return ZERO_DATE_TIME.plus(value);
    }

    public static Duration toDuration(LocalDateTime value) {
        return Duration.between(ZERO_DATE_TIME, value.withNano(0));
    }

    public static Period toPeriod(LocalDateTime value) {
        return Period.between(ZERO_DATE_TIME.toLocalDate(), value.toLocalDate());
    }

    public static TemporalAmount betweenNow(LocalDateTime value, TemporalUnit unit) {
        return TemporalAmountUtilities.between(UserDateTimeUtilities.now().toLocalDateTime(), value, unit);
    }

    public static TemporalAmount between(LocalDateTime from, LocalDateTime until, TemporalUnit unit) {
        if (unit.isDateBased()) {
            return Period.between(TemporalAmountUtilities.floor(from, unit).toLocalDate(), TemporalAmountUtilities.floor(until, unit).toLocalDate());
        }
        return Duration.between(TemporalAmountUtilities.floor(from, unit), TemporalAmountUtilities.floor(until, unit));
    }
}

