/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.anwiba.commons.utilities.time.IZonedDateTimeRange;

public class ZonedDateTimeRange
implements IZonedDateTimeRange {
    private static final long serialVersionUID = 1L;
    private final ZonedDateTime from;
    private final ZonedDateTime until;

    public static IZonedDateTimeRange of(ZonedDateTime from, Duration duration) {
        return new ZonedDateTimeRange(from, from.plus(duration));
    }

    public static IZonedDateTimeRange of(ZonedDateTime from, Period period) {
        return new ZonedDateTimeRange(from, from.plus(period));
    }

    public ZonedDateTimeRange(ZonedDateTime from, ZonedDateTime until) {
        this.from = from;
        this.until = until;
    }

    @Override
    public ZonedDateTime getFrom() {
        return this.from;
    }

    @Override
    public ZonedDateTime getUntil() {
        return this.until;
    }

    @Override
    public ZonedDateTime getCenter() {
        return this.from.plus(this.getDuration().dividedBy(2L));
    }

    @Override
    public Duration getDuration() {
        return Duration.between(this.from, this.until);
    }

    @Override
    public boolean interact(ZonedDateTime time) {
        if (time == null) {
            return false;
        }
        return (this.from.isBefore(time) || this.from.isEqual(time)) && this.getUntil().isAfter(time);
    }

    @Override
    public boolean interact(IZonedDateTimeRange segment) {
        if (segment == null) {
            return false;
        }
        if (segment.getUntil().equals(this.getFrom()) || segment.getUntil().isBefore(this.getFrom())) {
            return false;
        }
        return !segment.getFrom().equals(this.getUntil()) && !segment.getFrom().isAfter(this.getUntil());
    }

    @Override
    public IZonedDateTimeRange intersection(IZonedDateTimeRange segment) {
        if (!this.interact(segment)) {
            return null;
        }
        ZonedDateTime from = segment.getFrom().isAfter(this.getFrom()) ? segment.getFrom() : this.getFrom();
        ZonedDateTime until = segment.getUntil().isBefore(this.getUntil()) ? segment.getUntil() : this.getUntil();
        return new ZonedDateTimeRange(from, until);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.until);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonedDateTimeRange)) {
            return false;
        }
        ZonedDateTimeRange other = (ZonedDateTimeRange)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.until, other.until);
    }
}

