/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;

public class Version
implements IVersion {
    public static final Date defaultDate = new GregorianCalendar(0, 0, 0).getTime();
    public static final IVersion DUMMY = new Version(0, 0, ReleaseState.RELEASE, 0, ProductState.EXPERIMENTAL, defaultDate, 0);
    private final int major;
    private final int minor;
    private final int step;
    private final ReleaseState releaseState;
    private final ProductState productState;
    private final Date date;
    private final int buildCount;

    public Version(int major, int minor, ReleaseState releaseState, int step, ProductState productState, Date date, int buildCount) {
        this.major = major;
        this.minor = minor;
        this.releaseState = releaseState;
        this.step = step;
        this.productState = productState;
        this.date = new Date(date.getTime());
        this.buildCount = buildCount;
    }

    @Override
    public Date getDate() {
        return new Date(this.date.getTime());
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public ReleaseState getReleaseState() {
        return this.releaseState;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    @Override
    public ProductState getProductState() {
        return this.productState;
    }

    @Override
    public int getBuildCount() {
        return this.buildCount;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.buildCount;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.productState == null ? 0 : this.productState.hashCode());
        result = 31 * result + (this.releaseState == null ? 0 : this.releaseState.hashCode());
        result = 31 * result + this.step;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IVersion)) {
            return false;
        }
        IVersion other = (IVersion)obj;
        if (this.major != other.getMajor()) {
            return false;
        }
        if (this.minor != other.getMinor()) {
            return false;
        }
        if (this.step != other.getStep()) {
            return false;
        }
        if (this.buildCount != other.getBuildCount()) {
            return false;
        }
        return Objects.equals(this.date, other.getDate()) && Objects.equals((Object)this.productState, (Object)other.getProductState()) && Objects.equals((Object)this.releaseState, (Object)other.getReleaseState());
    }
}

