/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.VersionParser;

public class Version
implements IVersion {
    private static final long serialVersionUID = 1L;
    public static final ZonedDateTime defaultDate = ZonedDateTime.of(0, 1, 1, 0, 0, 0, 0, Clock.systemUTC().getZone());
    public static final IVersion DUMMY = new Version(0, 0, ReleaseState.RELEASE, 0, ProductState.EXPERIMENTAL, defaultDate, 0);
    private final int major;
    private final int minor;
    private final int step;
    private final ReleaseState releaseState;
    private final ProductState productState;
    private final ZonedDateTime date;
    private final int buildCount;

    public Version(int major, int minor, ReleaseState releaseState, int step, ProductState productState, ZonedDateTime date, int buildCount) {
        this.major = major;
        this.minor = minor;
        this.releaseState = releaseState;
        this.step = step;
        this.productState = productState;
        this.date = date;
        this.buildCount = buildCount;
    }

    public static IVersion of(String string) {
        return new VersionParser().parse(string);
    }

    public static IVersion of(String string, IVersion defaultValue) {
        try {
            return new VersionParser().parse(string);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public ZonedDateTime getDate() {
        return this.date;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public ReleaseState getReleaseState() {
        return this.releaseState;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    @Override
    public ProductState getProductState() {
        return this.productState;
    }

    @Override
    public int getBuildCount() {
        return this.buildCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buildCount;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.productState == null ? 0 : this.productState.hashCode());
        result = 31 * result + (this.releaseState == null ? 0 : this.releaseState.hashCode());
        result = 31 * result + this.step;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IVersion)) {
            return false;
        }
        IVersion other = (IVersion)obj;
        if (this.major != other.getMajor()) {
            return false;
        }
        if (this.minor != other.getMinor()) {
            return false;
        }
        if (this.step != other.getStep()) {
            return false;
        }
        if (this.buildCount != other.getBuildCount()) {
            return false;
        }
        return Objects.equals(this.date, other.getDate()) && Objects.equals((Object)this.productState, (Object)other.getProductState()) && Objects.equals((Object)this.releaseState, (Object)other.getReleaseState());
    }
}

