/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.Version;

public class VersionBuilder {
    private int major = 0;
    private int minor = 0;
    private ReleaseState releaseState = ReleaseState.RELEASE;
    private int step = 0;
    private ProductState productState = ProductState.STABLE;
    private int year = 0;
    private int month = 1;
    private int day = 1;
    private int hour = 0;
    private int minute = 0;
    private int count = 0;
    private final ZoneId timeZone = Clock.systemUTC().getZone();

    public VersionBuilder setMajor(int value) {
        if (value == Integer.MIN_VALUE) {
            this.major = 0;
        }
        this.major = value;
        return this;
    }

    public VersionBuilder setMinor(int value) {
        if (value == Integer.MIN_VALUE) {
            this.minor = 0;
        }
        this.minor = value;
        return this;
    }

    public VersionBuilder setStep(int value) {
        if (value == Integer.MIN_VALUE) {
            this.step = 0;
        }
        this.step = value;
        return this;
    }

    public VersionBuilder setReleaseState(ReleaseState releaseState) {
        this.releaseState = releaseState;
        return this;
    }

    public VersionBuilder setProductState(ProductState productState) {
        this.productState = productState;
        return this;
    }

    public VersionBuilder setYear(int value) {
        if (value == Integer.MIN_VALUE) {
            this.year = 0;
        }
        this.year = value;
        return this;
    }

    public VersionBuilder setMonth(int value) {
        if (value == Integer.MIN_VALUE) {
            this.month = 0;
        }
        this.month = value;
        return this;
    }

    public VersionBuilder setDay(int value) {
        if (value == Integer.MIN_VALUE) {
            this.day = 0;
        }
        this.day = value;
        return this;
    }

    public VersionBuilder setHour(int value) {
        if (value == Integer.MIN_VALUE) {
            this.hour = 0;
        }
        this.hour = value;
        return this;
    }

    public VersionBuilder setMinute(int value) {
        if (value == Integer.MIN_VALUE) {
            this.minute = 0;
        }
        this.minute = value;
        return this;
    }

    public VersionBuilder setCount(int value) {
        if (value == Integer.MIN_VALUE) {
            this.count = 0;
        }
        this.count = value;
        return this;
    }

    public IVersion build() {
        return new Version(this.major, this.minor, this.releaseState, this.step, this.productState, ZonedDateTime.of(this.year, this.month, this.day, this.hour, this.minute, 0, 0, this.timeZone), this.count);
    }

    public VersionBuilder setMajor(String value) {
        this.setMajor(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMinor(String value) {
        this.setMinor(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setStep(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setYear(String value) {
        this.setYear(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMonth(String value) {
        this.setMonth(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setDay(String value) {
        this.setDay(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setHour(String value) {
        this.setHour(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMinute(String value) {
        this.setMinute(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setCount(String value) {
        this.setCount(this.convertToInt(value));
        return this;
    }

    private int convertToInt(String value) {
        if (this.isBlank(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.valueOf(value.trim());
    }

    public VersionBuilder setProductState(String string) {
        if (this.isBlank(string)) {
            this.productState = ProductState.STABLE;
            return this;
        }
        String upperCase = string.toUpperCase();
        for (ProductState state : ProductState.values()) {
            if (!Objects.equals(upperCase, state.getAcronym()) && !Objects.equals(upperCase, state.name())) continue;
            this.productState = state;
            return this;
        }
        this.productState = ProductState.STABLE;
        return this;
    }

    public VersionBuilder setReleaseState(String string) {
        if (this.isBlank(string)) {
            this.releaseState = ReleaseState.RELEASE;
            return this;
        }
        String upperCase = string.toUpperCase();
        for (ReleaseState state : ReleaseState.values()) {
            if (!Objects.equals(upperCase, state.getAcronym()) && !Objects.equals(upperCase, state.name())) continue;
            this.releaseState = state;
            return this;
        }
        this.releaseState = ReleaseState.RELEASE;
        return this;
    }

    protected boolean isBlank(String string) {
        return string == null || string.isBlank();
    }
}

