/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.Version;
import net.anwiba.commons.version.VersionParser;

public class VersionUtilities {
    /*
     * Enabled aggressive exception aggregation
     */
    public static IVersion getVersion(URL resource) {
        if (resource == null) {
            return Version.DUMMY;
        }
        Properties properties = new Properties();
        try (InputStream inputstream = resource.openStream();){
            Version version;
            try (InputStreamReader reader = new InputStreamReader(inputstream, "UTF-8");){
                properties.load(reader);
                int major = VersionUtilities.getIntProperty(properties, "version.mayor");
                int minor = VersionUtilities.getIntProperty(properties, "version.minor");
                int step = VersionUtilities.getIntProperty(properties, "version.step");
                ReleaseState releaseState = VersionUtilities.getReleaseState(properties);
                ProductState productState = VersionUtilities.getProductState(properties);
                int buildCount = VersionUtilities.getIntProperty(properties, "build.count");
                ZonedDateTime date = VersionUtilities.getDate(properties);
                version = new Version(major, minor, releaseState, step, productState, date, buildCount);
            }
            return version;
        }
        catch (IOException iOException) {
            return Version.DUMMY;
        }
    }

    private static ZonedDateTime getDate(Properties properties) {
        String property = properties.getProperty("build.date");
        if (property == null) {
            return Version.defaultDate;
        }
        try {
            return ZonedDateTime.of(LocalDateTime.parse(property, DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm", Locale.getDefault())), Clock.systemUTC().getZone());
        }
        catch (DateTimeParseException exception) {
            return Version.defaultDate;
        }
    }

    private static ProductState getProductState(Properties properties) {
        String property = properties.getProperty("version.state.product");
        if (property == null) {
            return ProductState.EXPERIMENTAL;
        }
        try {
            return ProductState.valueOf(property);
        }
        catch (IllegalArgumentException e) {
            return ProductState.EXPERIMENTAL;
        }
    }

    private static ReleaseState getReleaseState(Properties properties) {
        String property = properties.getProperty("version.state.release");
        if (property == null) {
            return ReleaseState.RELEASE;
        }
        try {
            return ReleaseState.valueOf(property);
        }
        catch (IllegalArgumentException e) {
            return ReleaseState.RELEASE;
        }
    }

    private static int getIntProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static IVersion valueOf(String string) {
        return new VersionParser().parse(string);
    }

    public static String getText(IVersion version) {
        Object string = VersionUtilities.internal(version);
        ProductState productState = version.getProductState();
        if (productState != ProductState.STABLE) {
            string = (String)string + " ";
            string = (String)string + String.valueOf(productState.getAcronym());
        }
        return string;
    }

    private static String internal(IVersion version) {
        Object string = String.valueOf(version.getMajor());
        string = (String)string + ".";
        string = (String)string + String.valueOf(version.getMinor());
        ReleaseState releaseState = version.getReleaseState();
        string = releaseState != ReleaseState.RELEASE ? (String)string + String.valueOf(releaseState.getAcronym()) : (String)string + ".";
        string = (String)string + String.valueOf(version.getStep());
        return string;
    }

    public static String getTextLong(IVersion version) {
        Object string = VersionUtilities.internal(version);
        ProductState productState = version.getProductState();
        string = (String)string + " ";
        string = (String)string + String.valueOf(productState.getAcronym());
        string = (String)string + " ";
        string = (String)string + version.getBuildCount();
        string = (String)string + " ";
        string = (String)string + version.getDate().format(DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm", Locale.getDefault()));
        return string;
    }

    public static String getTextShort(IVersion version) {
        return VersionUtilities.internal(version);
    }

    public static boolean isGreaterThan(IVersion version, IVersion other) {
        if (version.getMajor() > other.getMajor()) {
            return true;
        }
        if (version.getMinor() > other.getMinor()) {
            return true;
        }
        if (version.getStep() > other.getStep()) {
            return true;
        }
        if (version.getBuildCount() > other.getBuildCount()) {
            return true;
        }
        if (version.getReleaseState().ordinal() > other.getReleaseState().ordinal()) {
            return true;
        }
        if (version.getReleaseState().ordinal() > other.getProductState().ordinal()) {
            return true;
        }
        return version.getDate().isAfter(other.getDate());
    }

    public static boolean isGreaterEquals(IVersion version, IVersion other) {
        if (Objects.equals(version, other)) {
            return true;
        }
        if (version.getMajor() < other.getMajor()) {
            return false;
        }
        if (version.getMajor() > other.getMajor()) {
            return true;
        }
        if (version.getMinor() < other.getMinor()) {
            return false;
        }
        if (version.getMinor() > other.getMinor()) {
            return true;
        }
        if (version.getStep() < other.getStep()) {
            return false;
        }
        if (version.getStep() > other.getStep()) {
            return true;
        }
        if (version.getBuildCount() < other.getBuildCount()) {
            return false;
        }
        if (version.getBuildCount() > other.getBuildCount()) {
            return true;
        }
        if (version.getReleaseState().ordinal() < other.getReleaseState().ordinal()) {
            return false;
        }
        if (version.getReleaseState().ordinal() > other.getReleaseState().ordinal()) {
            return true;
        }
        if (version.getReleaseState().ordinal() < other.getProductState().ordinal()) {
            return false;
        }
        if (version.getReleaseState().ordinal() > other.getProductState().ordinal()) {
            return true;
        }
        if (version.getDate().isBefore(other.getDate())) {
            return false;
        }
        if (version.getDate().isAfter(other.getDate())) {
            return true;
        }
        return true;
    }
}

