/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.workflow;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.workflow.DefaultDelegatingExecuterFactory;
import net.anwiba.commons.workflow.EventDispatchThreadUsingDelegatingExecuterFactory;
import net.anwiba.commons.workflow.IExecutable;
import net.anwiba.commons.workflow.IExecuterFactory;
import net.anwiba.commons.workflow.IWorkflow;
import net.anwiba.commons.workflow.IWorkflowBuilder;
import net.anwiba.commons.workflow.IWorkflowController;
import net.anwiba.commons.workflow.Workflow;
import net.anwiba.commons.workflow.WorkflowController;
import net.anwiba.commons.workflow.state.IState;
import net.anwiba.commons.workflow.transition.ITransition;
import net.anwiba.commons.workflow.transition.Transition;

public class WorkflowBuilder<T>
implements IWorkflowBuilder<T> {
    private IExecuterFactory<T> closureDelegatorFactory = new DefaultDelegatingExecuterFactory();
    private final List<ITransition<T>> transitions = new ArrayList<ITransition<T>>();
    private IWorkflowController<T> workflowController = null;

    @Override
    public IWorkflowBuilder<T> add(IApplicable<IState<T>> applicable, IExecutable<T> executable) {
        this.add(new Transition<T>(applicable, s -> executable));
        return this;
    }

    @Override
    public IWorkflowBuilder<T> add(ITransition<T> transition) {
        if (this.workflowController != null) {
            throw new IllegalArgumentException();
        }
        this.transitions.add(transition);
        return this;
    }

    @Override
    public IWorkflowBuilder<T> add(IApplicable<IState<T>> applicable, IFunction<IState<T>, IExecutable<T>, RuntimeException> factory) {
        this.add(new Transition<T>(applicable, factory));
        return this;
    }

    @Override
    public IWorkflowBuilder<T> setClosureDelegatorFactory(IExecuterFactory<T> closureDelegatorFactory) {
        this.closureDelegatorFactory = closureDelegatorFactory;
        return this;
    }

    @Override
    public IWorkflowBuilder<T> setWorkflowController(IWorkflowController<T> workflowController) {
        if (!this.transitions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.workflowController = workflowController;
        return this;
    }

    @Override
    public IWorkflowBuilder<T> setEventDispatchThreadExecuter() {
        this.closureDelegatorFactory = new EventDispatchThreadUsingDelegatingExecuterFactory();
        return this;
    }

    @Override
    public IWorkflow<T> build() {
        this.workflowController = new WorkflowController<T>(this.transitions);
        return new Workflow<T>(this.closureDelegatorFactory, this.workflowController);
    }
}

