/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.VersionBuilder;
import net.anwiba.commons.version.VersionUtilities;

public class XmlStreamStartElementNameAndVersionExtractor {
    private static final String VERSION = "version";

    public ObjectPair<String, IVersion> extract(InputStream inputStream) throws IOException {
        return (ObjectPair)XmlStreamStartElementNameAndVersionExtractor.process(inputStream, event -> this.process((StartElement)event));
    }

    private ObjectPair<String, IVersion> process(StartElement element) {
        QName attributeName = new QName(VERSION);
        Attribute attribute = element.getAttributeByName(attributeName);
        return new ObjectPair((Object)element.getName().getLocalPart(), attribute == null ? null : this.convertToVersion(attribute.getValue()));
    }

    public static <R, E extends Exception> R process(InputStream inputStream, IFunction<StartElement, R, E> function) throws E, IOException {
        try {
            inputStream.mark(inputStream.available());
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                Object object = function.execute((Object)event.asStartElement());
                return (R)object;
            }
            return null;
        }
        catch (XMLStreamException cause) {
            throw new IOException(cause);
        }
        finally {
            inputStream.reset();
        }
    }

    private IVersion convertToVersion(String value) {
        return (IVersion)Optional.of((Object)value).convert(s -> VersionUtilities.valueOf((String)s)).convert(v -> Objects.equals(new VersionBuilder().build(), v) ? null : v).getOr(() -> null);
    }
}

