/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.io.NoneClosingInputStream;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.Parameters;
import net.anwiba.commons.xml.io.IRegistableConvertingXmlPersister;
import net.anwiba.commons.xml.jaxb.JaxbTransformer;

public class RegistableConvertingXmlPersisterFactory {
    private static ILogger logger = Logging.getLogger((String)RegistableConvertingXmlPersisterFactory.class.getName());
    private final IFunction<String, InputStream, IOException> connector;

    public RegistableConvertingXmlPersisterFactory() {
        this(new IFunction<String, InputStream, IOException>(){

            public InputStream execute(String script) throws IOException {
                return new BufferedInputStream(this.getClass().getResourceAsStream(script));
            }
        });
    }

    public RegistableConvertingXmlPersisterFactory(IFunction<String, InputStream, IOException> connector) {
        this.connector = connector;
    }

    public <C, T> IRegistableConvertingXmlPersister<C, T> create(final IApplicable<C> applicable, URIResolver uriResolver, String inputXsltScript, String outputXsltScript, Class<?> ... bindingClasses) throws CreationException {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            transformerFactory.setURIResolver(uriResolver);
            Templates inputTransformerTemplate = this.create(inputXsltScript, transformerFactory);
            Templates outputTransformerTemplate = this.create(outputXsltScript, transformerFactory);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])bindingClasses);
            final JaxbTransformer jaxbTransformer = new JaxbTransformer(transformerFactory, inputTransformerTemplate, outputTransformerTemplate, jaxbContext);
            return new IRegistableConvertingXmlPersister<C, T>(){

                public boolean isApplicable(C context) {
                    return applicable.isApplicable(context);
                }

                @Override
                public T read(InputStream inputStream) throws IOException {
                    try {
                        return jaxbTransformer.unmarshall(inputStream, (IParameters)new Parameters(Collections.emptyList()));
                    }
                    catch (JAXBException | TransformerException exception) {
                        throw new IOException(exception);
                    }
                }

                @Override
                public void write(T object, OutputStream outputStream) throws IOException {
                    try {
                        jaxbTransformer.marshall(object, outputStream);
                    }
                    catch (JAXBException | TransformerException exception) {
                        throw new IOException(exception);
                    }
                }
            };
        }
        catch (JAXBException | TransformerConfigurationException exception) {
            throw new CreationException("Couldn't create xml converting persister for binding '" + Arrays.toString(bindingClasses) + ",", exception);
        }
        catch (IOException exception) {
            throw new CreationException("Couldn't create xml converting persister for xsd resource '" + inputXsltScript + ",", (Throwable)exception);
        }
    }

    private Templates create(String inputXsltScript, SAXTransformerFactory transformerFactory) throws TransformerConfigurationException, IOException {
        if (inputXsltScript == null) {
            return null;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = (InputStream)this.connector.execute((Object)inputXsltScript);){
            if (logger.isLoggable(ILevel.DEBUG)) {
                logger.log(ILevel.DEBUG, inputXsltScript);
            }
            return transformerFactory.newTemplates(new StreamSource((InputStream)new NoneClosingInputStream(stream)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

