/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.util.List;
import net.anwiba.commons.xml.dom.DomConverterException;
import org.dom4j.Element;
import org.dom4j.QName;

public interface IDomToObjectConverter<T> {
    public T convert(Element var1) throws DomConverterException;

    default public List<Element> elements(Element element, QName name) {
        return element.elements(name);
    }

    default public String value(Element element, String attributeName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return attributeValue;
    }

    default public boolean booleanValue(Element element, String attributeName) throws DomConverterException {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        return Boolean.valueOf(attributeValue);
    }

    default public boolean booleanValue(Element element, String attributeName, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(attributeValue);
    }

    default public int intValue(Element element, String attributeName) throws DomConverterException {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        return Integer.valueOf(attributeValue);
    }

    default public int intValue(Element element, String attributeName, int defaultValue) {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return Integer.valueOf(attributeValue);
    }

    default public double doubleValue(Element element, String attributeName) throws DomConverterException {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        return Double.valueOf(attributeValue);
    }

    default public double doubleValue(Element element, String attributeName, double defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return Double.valueOf(attributeValue);
    }

    default public <V> void addTo(List<V> list, V value) {
        if (value == null) {
            return;
        }
        list.add(value);
    }
}

