/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.jaxb;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.anwiba.commons.xml.jaxb.IJaxbContext;

public class JaxbContextBuilder {
    List<Class<?>> objectFactories = new ArrayList();
    List<Source> schemaSources = new ArrayList<Source>();

    public JaxbContextBuilder add(Class<?> objectFactory, String schemaSource) {
        this.add(objectFactory, this.getSourceSchema(schemaSource));
        return this;
    }

    public JaxbContextBuilder add(Class<?> objectFactory, Source schemaSource) {
        this.objectFactories.add(objectFactory);
        this.schemaSources.add(schemaSource);
        return this;
    }

    private Source getSourceSchema(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException();
        }
        URL resource = this.getClass().getResource(filename);
        return new StreamSource(resource.toString());
    }

    public IJaxbContext build() {
        return new JaxbContext(this.objectFactories, this.schemaSources);
    }

    public static final class JaxbContext
    implements IJaxbContext {
        private final List<Class<?>> objectFactories;
        private final List<Source> schemaSources;

        public JaxbContext(List<Class<?>> objectFactories, List<Source> schemaSources) {
            this.objectFactories = objectFactories;
            this.schemaSources = schemaSources;
        }

        @Override
        public Class<?>[] getObjectFactories() {
            return this.objectFactories.toArray(new Class[this.objectFactories.size()]);
        }

        @Override
        public Source[] getSchemaSources() {
            return this.schemaSources.toArray(new Source[this.schemaSources.size()]);
        }
    }
}

