/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.primitive.IBooleanProvider;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.utilities.io.IClosableConnector;
import net.anwiba.commons.utilities.io.IClosableIoIterator;
import net.anwiba.commons.xml.dom.DomConverterException;
import net.anwiba.commons.xml.dom.IDomToObjectConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class DomElementIterator<T>
implements IClosableIoIterator<T> {
    private final IClosableConnector connector;
    private final IAcceptor<XMLEvent> acceptor;
    private final IDomToObjectConverter<T> converter;
    private IAcceptor<XMLEvent> errorAcceptor;
    private final Function<Element, IOException> exceptionFactory;
    private boolean isClosed = false;
    private XMLEventReader eventReader = null;
    private T object = null;
    private InputStream inputStream;
    private IBooleanProvider terminate;

    public DomElementIterator(IClosableConnector connector, IAcceptor<XMLEvent> acceptor, IDomToObjectConverter<T> converter) {
        this(() -> false, connector, acceptor, converter, (IAcceptor<XMLEvent>)((IAcceptor)event -> false), element -> null);
    }

    public DomElementIterator(IBooleanProvider terminate, IClosableConnector connector, IAcceptor<XMLEvent> acceptor, IDomToObjectConverter<T> converter, IAcceptor<XMLEvent> errorAcceptor, Function<Element, IOException> errorConsumer) {
        this.terminate = terminate;
        this.connector = connector;
        this.acceptor = acceptor;
        this.converter = converter;
        this.errorAcceptor = errorAcceptor;
        this.exceptionFactory = errorConsumer;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.object = null;
        IOException ioException = IoUtilities.close(() -> {
            if (this.eventReader != null) {
                try {
                    this.eventReader.close();
                }
                catch (XMLStreamException exception) {
                    throw new IOException(exception.getMessage(), exception);
                }
            }
        }, null);
        ioException = IoUtilities.close((Closeable)this.inputStream, (IOException)ioException);
        if ((ioException = IoUtilities.close((Closeable)this.connector, (IOException)ioException)) != null) {
            throw ioException;
        }
    }

    public boolean hasNext() throws IOException {
        if (this.isClosed) {
            throw new IOException("Iterator is closed");
        }
        if (this.terminate.isTrue()) {
            return false;
        }
        if (this.object != null) {
            return true;
        }
        try {
            if (this.eventReader == null) {
                this.eventReader = this.initialize();
            }
            while (this.eventReader.hasNext()) {
                Element element;
                IOException exception;
                XMLEvent event = this.eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                if (this.errorAcceptor.accept((Object)event) && (exception = this.exceptionFactory.apply(element = this.convert(event.asStartElement()))) != null) {
                    throw exception;
                }
                if (!this.acceptor.accept((Object)event)) continue;
                element = this.convert(event.asStartElement());
                this.object = this.converter.convert(element);
                return this.object != null;
            }
            return false;
        }
        catch (ClassCastException | XMLStreamException | DomConverterException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private Element convert(StartElement element) throws XMLStreamException, IOException {
        Element resultElement = this.create(element);
        QName qName = this.getQName(element);
        while (this.eventReader.hasNext()) {
            String data;
            Element childElement;
            IOException exception;
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement() && this.errorAcceptor.accept((Object)event) && (exception = this.exceptionFactory.apply(childElement = this.convert(event.asStartElement()))) != null) {
                throw exception;
            }
            if (event.isEndElement() && Objects.equals(qName, this.getQName(event))) {
                return resultElement;
            }
            if (event.isStartElement()) {
                childElement = this.convert(event.asStartElement());
                resultElement.add(childElement);
            }
            if (!event.isCharacters() || (data = event.asCharacters().getData()).isBlank()) continue;
            resultElement.add(DocumentHelper.createText((String)data));
        }
        return resultElement;
    }

    private QName getQName(XMLEvent value) {
        QName name = value.isStartElement() ? value.asStartElement().getName() : (value.isEndElement() ? value.asEndElement().getName() : null);
        return name;
    }

    private Element create(StartElement element) {
        Element resultElement = DocumentHelper.createElement((org.dom4j.QName)this.convert(element.getName()));
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            resultElement.addAttribute(this.convert(attribute.getName()), attribute.getValue());
        }
        return resultElement;
    }

    private org.dom4j.QName convert(QName name) {
        Namespace namespace = name.getPrefix() != null && name.getNamespaceURI() != null ? new Namespace(name.getPrefix(), name.getNamespaceURI()) : Namespace.NO_NAMESPACE;
        return new org.dom4j.QName(name.getLocalPart(), namespace);
    }

    private XMLEventReader initialize() throws FactoryConfigurationError, XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inputStream = this.connector.connect();
        return inputFactory.createXMLEventReader(this.inputStream);
    }

    public T next() throws IOException {
        try {
            if (this.hasNext()) {
                T t = this.object;
                return t;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.object = null;
        }
    }
}

