/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.xml.io.IRegistableConvertingXmlWriter;
import net.anwiba.commons.xml.io.TemplateFactory;
import net.anwiba.commons.xml.jaxb.IJaxbContext;
import net.anwiba.commons.xml.jaxb.JaxbTransformer;

public class RegistableConvertingXmlWriterFactory {
    private static ILogger logger = Logging.getLogger((String)RegistableConvertingXmlWriterFactory.class.getName());
    private final TemplateFactory templateFactory;

    public RegistableConvertingXmlWriterFactory() {
        this(new IFunction<String, InputStream, IOException>(){

            public InputStream execute(String script) throws IOException {
                ByteArrayInputStream byteArrayInputStream;
                block8: {
                    InputStream stream = this.getClass().getResourceAsStream(script);
                    try {
                        byte[] byteArray = IoUtilities.toByteArray((InputStream)stream);
                        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArray);
                        byteArrayInputStream2.mark(byteArray.length + 1);
                        byteArrayInputStream = byteArrayInputStream2;
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException exception) {
                            return null;
                        }
                    }
                    stream.close();
                }
                return byteArrayInputStream;
            }
        });
    }

    public RegistableConvertingXmlWriterFactory(IFunction<String, InputStream, IOException> connector) {
        this.templateFactory = new TemplateFactory(connector);
    }

    public <C, T> IRegistableConvertingXmlWriter<C, T> create(final IApplicable<C> applicable, URIResolver uriResolver, String outputXsltScript, IJaxbContext jaxbContext) throws CreationException {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            transformerFactory.setURIResolver(uriResolver);
            Templates outputTransformerTemplate = this.templateFactory.create(outputXsltScript, transformerFactory);
            final JaxbTransformer jaxbTransformer = new JaxbTransformer(transformerFactory, null, outputTransformerTemplate, JAXBContext.newInstance((String)jaxbContext.getContextPath(), (ClassLoader)jaxbContext.getClassLoader()));
            return new IRegistableConvertingXmlWriter<C, T>(){

                public boolean isApplicable(C context) {
                    return applicable.isApplicable(context);
                }

                @Override
                public void write(T object, IParameters parameters, OutputStream outputStream, IProperties outputProperties) throws IOException {
                    try {
                        jaxbTransformer.marshall(object, parameters, outputStream, outputProperties);
                    }
                    catch (JAXBException | TransformerException exception) {
                        throw new IOException(exception);
                    }
                }
            };
        }
        catch (JAXBException | TransformerConfigurationException exception) {
            throw new CreationException("Couldn't create xml converting persister for binding '" + Arrays.toString(jaxbContext.getObjectFactories()) + ",", exception);
        }
        catch (IOException exception) {
            throw new CreationException("Couldn't create xml converting persister with xslt script '" + outputXsltScript + "',", (Throwable)exception);
        }
    }
}

