/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.io.NoneClosingInputStream;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.xml.io.RegistableConvertingXmlReaderFactory;

public class TemplateFactory {
    private final IFunction<String, InputStream, IOException> connector;

    public TemplateFactory(IFunction<String, InputStream, IOException> connector) {
        this.connector = connector;
    }

    public Templates create(String xsltScript, SAXTransformerFactory transformerFactory) throws TransformerConfigurationException, IOException {
        if (xsltScript == null) {
            return null;
        }
        try (InputStream stream = (InputStream)this.connector.execute((Object)xsltScript);){
            if (RegistableConvertingXmlReaderFactory.logger.isLoggable(ILevel.DEBUG)) {
                RegistableConvertingXmlReaderFactory.logger.log(ILevel.DEBUG, xsltScript);
            }
            Templates templates = transformerFactory.newTemplates(new StreamSource((InputStream)new NoneClosingInputStream(stream)));
            return templates;
        }
    }
}

