/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.jaxb;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.anwiba.commons.xml.jaxb.IJaxbContext;

public class JaxbContextBuilder {
    ClassLoader classLoader = this.getClass().getClassLoader();
    List<Class<?>> objectFactories = new ArrayList();
    List<Source> schemaSources = new ArrayList<Source>();

    public JaxbContextBuilder add(Class<?> objectFactory, String schemaSource) {
        this.add(objectFactory, this.getSourceSchema(objectFactory, schemaSource));
        return this;
    }

    public JaxbContextBuilder add(Class<?> objectFactory, Source schemaSource) {
        this.objectFactories.add(objectFactory);
        this.schemaSources.add(schemaSource);
        return this;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Source getSourceSchema(Class<?> objectFactory, String filename) {
        if (filename == null) {
            throw new IllegalArgumentException();
        }
        URL resource = objectFactory.getResource(filename);
        return new StreamSource(resource.toString());
    }

    public IJaxbContext build() {
        return new JaxbContext(this.objectFactories, this.schemaSources, this.classLoader);
    }

    public static final class JaxbContext
    implements IJaxbContext {
        private final List<Class<?>> objectFactories;
        private final List<Source> schemaSources;
        private final ClassLoader classLoader;

        public JaxbContext(List<Class<?>> objectFactories, List<Source> schemaSources, ClassLoader classLoader) {
            this.objectFactories = objectFactories;
            this.schemaSources = schemaSources;
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public Class<?>[] getObjectFactories() {
            return this.objectFactories.toArray(new Class[this.objectFactories.size()]);
        }

        @Override
        public Source[] getSchemaSources() {
            return this.schemaSources.toArray(new Source[this.schemaSources.size()]);
        }
    }
}

