/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.List;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;
import net.anwiba.commons.xml.dom.DomConverterException;
import org.dom4j.Element;
import org.dom4j.QName;

public interface IDomToObjectConverter<T> {
    public T convert(Element var1) throws DomConverterException;

    default public Element element(Element element, QName name) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for element '" + name + "'");
        }
        return element.element(name);
    }

    default public Element element(Element element, String name) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for element '" + name + "'");
        }
        return element.element(name);
    }

    default public List<Element> elements(Element element, QName name) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for elements '" + name + "'");
        }
        return element.elements(name);
    }

    default public List<Element> elements(Element element, String name) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for elements '" + name + "'");
        }
        return element.elements(name);
    }

    default public String text(Element element) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element");
        }
        return element.getText();
    }

    default public String text(Element element, String defaultText) {
        if (element == null) {
            return defaultText;
        }
        return element.getTextTrim();
    }

    default public String value(Element element, String attributeName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return attributeValue;
    }

    default public String value(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        return attributeValue;
    }

    default public Duration durationValue(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "', value '" + attributeValue + "'");
        }
        try {
            return Duration.parse(attributeValue);
        }
        catch (DateTimeParseException e) {
            throw new DomConverterException(e.getMessage(), e);
        }
    }

    default public Duration durationValue(Element element, String attributeName, Duration defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return Duration.parse(attributeValue);
        }
        catch (DateTimeParseException e) {
            throw new DomConverterException(e.getMessage(), e);
        }
    }

    default public boolean booleanValue(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "', value '" + attributeValue + "'");
        }
        return Boolean.valueOf(attributeValue);
    }

    default public boolean booleanValue(Element element, String attributeName, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(attributeValue);
    }

    default public int intValue(Element element, int defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getTextTrim();
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + element.getName() + "', value '" + value + "'");
        }
    }

    default public int intValue(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "', value '" + attributeValue + "'");
        }
        return Integer.valueOf(attributeValue);
    }

    default public int intValue(Element element, String attributeName, int defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(attributeValue);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + attributeName + "', value '" + attributeValue + "'");
        }
    }

    default public float floatValue(Element element, String attributeName, float defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(attributeValue).floatValue();
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + attributeName + "', value '" + attributeValue + "'");
        }
    }

    default public double doubleValue(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        try {
            return Double.valueOf(attributeValue);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + attributeName + "', value '" + attributeValue + "'");
        }
    }

    default public double doubleValue(Element element, String attributeName, double defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(attributeValue);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + attributeName + "', value '" + attributeValue + "'");
        }
    }

    default public double doubleValue(Element element, double defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getTextTrim();
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException("Number format exception for attribut '" + element.getName() + "', value '" + value + "'");
        }
    }

    default public ZonedDateTime dateTimeValue(Element element, String attributeName) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("Missing element for attribute '" + attributeName + "'");
        }
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            throw new DomConverterException("Missing attribute '" + attributeName + "'");
        }
        try {
            return ZonedDateTimeUtilities.valueOf((String)attributeValue);
        }
        catch (DateTimeParseException exception) {
            throw new DomConverterException("Date time parse exception for attribut '" + attributeName + "', value '" + attributeValue + "'");
        }
    }

    default public <V> void addTo(List<V> list, V value) {
        if (value == null) {
            return;
        }
        list.add(value);
    }
}

