/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.xml.io.IRegistableConvertingXmlReader;
import net.anwiba.commons.xml.io.TemplateFactory;
import net.anwiba.commons.xml.jaxb.IJaxbContext;
import net.anwiba.commons.xml.jaxb.JaxbTransformer;

public class RegistableConvertingXmlReaderFactory {
    static ILogger logger = Logging.getLogger((String)RegistableConvertingXmlReaderFactory.class.getName());
    private final TemplateFactory templateFactory;

    public RegistableConvertingXmlReaderFactory() {
        this(new IFunction<String, InputStream, IOException>(){

            public InputStream execute(String script) throws IOException {
                return new BufferedInputStream(this.getClass().getResourceAsStream(script));
            }
        });
    }

    public RegistableConvertingXmlReaderFactory(IFunction<String, InputStream, IOException> connector) {
        this.templateFactory = new TemplateFactory(connector);
    }

    public <C, T> IRegistableConvertingXmlReader<C, T> create(final IApplicable<C> applicable, URIResolver uriResolver, String inputXsltScript, IJaxbContext jaxbContext) throws CreationException {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            transformerFactory.setURIResolver(uriResolver);
            Templates inputTransformerTemplate = this.templateFactory.create(inputXsltScript, transformerFactory);
            final JaxbTransformer jaxbTransformer = new JaxbTransformer(transformerFactory, inputTransformerTemplate, null, JAXBContext.newInstance((String)jaxbContext.getContextPath(), (ClassLoader)jaxbContext.getClassLoader()));
            return new IRegistableConvertingXmlReader<C, T>(){

                public boolean isApplicable(C context) {
                    return applicable.isApplicable(context);
                }

                @Override
                public T read(InputStream inputStream, IParameters parameters) throws IOException {
                    try {
                        return jaxbTransformer.unmarshall(inputStream, parameters);
                    }
                    catch (JAXBException | TransformerException exception) {
                        throw new IOException(exception);
                    }
                }
            };
        }
        catch (JAXBException | TransformerConfigurationException exception) {
            throw new CreationException("Couldn't create xml converting persister for binding '" + Arrays.toString(jaxbContext.getObjectFactories()) + ",", exception);
        }
        catch (IOException exception) {
            throw new CreationException("Couldn't create xml converting persister for xslt script '" + inputXsltScript + "', ", (Throwable)exception);
        }
    }
}

