/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.xml.dom.DomConverterException;
import net.anwiba.commons.xml.dom.IDomToObjectConverter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class XmlReader<T>
implements Closeable {
    private final IDomToObjectConverter<T> converter;
    private final InputStream inputStream;

    public XmlReader(InputStream stream, IDomToObjectConverter<T> converter) {
        this.inputStream = stream;
        this.converter = converter;
    }

    public T read() throws DomConverterException {
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(this.inputStream);
            return this.converter.convert(document.getRootElement());
        }
        catch (DocumentException exception) {
            throw new DomConverterException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        IoUtilities.close((Closeable)this.inputStream);
    }
}

