/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import net.anwiba.commons.xml.dom.IObjectToDomConverter;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlWriter<T>
implements Closeable {
    private final IObjectToDomConverter<T> converter;
    private final XMLWriter xmlWriter;

    public XmlWriter(Writer writer, IObjectToDomConverter<T> converter) {
        this.converter = converter;
        this.xmlWriter = new XMLWriter(writer, new OutputFormat(" ", true));
    }

    public void write(T object) throws IOException {
        DocumentFactory instance = DocumentFactory.getInstance();
        Document document = instance.createDocument();
        document.add(this.converter.convert(object));
        this.xmlWriter.write(document);
    }

    @Override
    public void close() throws IOException {
        this.xmlWriter.close();
    }
}

