/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.jaxb;

import net.anwiba.commons.xml.xsd.XsdElementsFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class JaxbElementsFactory {
    public static final Namespace JAXB_NAMESPACE = new Namespace("jaxb", "https://jakarta.ee/xml/ns/jaxb");

    public static Element createSchemaElement(String packageName) {
        Element element = DocumentHelper.createElement((QName)XsdElementsFactory.SCHEMA);
        element.add(JAXB_NAMESPACE);
        element.addAttribute(XsdElementsFactory.createName("elementFormDefault"), "qualified");
        element.addAttribute(JaxbElementsFactory.createJaxbName("version"), "3.0");
        element.add(JaxbElementsFactory.createGlobalBindingsAnnotation(packageName));
        return element;
    }

    public static Element createClassAnnotation(String className) {
        Element element = DocumentHelper.createElement((QName)JaxbElementsFactory.createJaxbName("class"));
        element.addAttribute(XsdElementsFactory.createName("name"), className);
        return XsdElementsFactory.createApplicationInfoAnnotation(element);
    }

    public static Element createGlobalBindingsAnnotation(String packageName) {
        Element element = DocumentHelper.createElement((QName)JaxbElementsFactory.createJaxbName("globalBindings"));
        element.addAttribute(XsdElementsFactory.createName("generateIsSetMethod"), "true");
        if (packageName == null) {
            return XsdElementsFactory.createApplicationInfoAnnotation(element);
        }
        Element schemaBindingsElement = JaxbElementsFactory.createSchemaBindingsElement(packageName);
        return XsdElementsFactory.createApplicationInfoAnnotation(element, schemaBindingsElement);
    }

    public static Element createSchemaBindingsElement(String packageName) {
        Element schemaBindingsElement = DocumentHelper.createElement((QName)JaxbElementsFactory.createJaxbName("schemaBindings"));
        Element packageElement = DocumentHelper.createElement((QName)JaxbElementsFactory.createJaxbName("package"));
        packageElement.addAttribute(XsdElementsFactory.createName("name"), packageName);
        schemaBindingsElement.add(packageElement);
        return schemaBindingsElement;
    }

    public static QName createJaxbName(String name) {
        return new QName(name, JAXB_NAMESPACE);
    }

    public static Element createSimpleTypeElement(String typeName, String className, String baseTypeName) {
        Element restrictionElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName("restriction"));
        restrictionElement.addAttribute(XsdElementsFactory.createName("base"), baseTypeName);
        Element simpleTypeElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName("simpleType"));
        simpleTypeElement.addAttribute(XsdElementsFactory.createName("name"), typeName);
        simpleTypeElement.add(JaxbElementsFactory.createClassAnnotation(className));
        simpleTypeElement.add(restrictionElement);
        return simpleTypeElement;
    }

    public static Element createComplexTypeElement(String typeName, String className, Element structurElement) {
        Element complexTypeElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName("complexType"));
        complexTypeElement.addAttribute(XsdElementsFactory.createName("name"), typeName);
        complexTypeElement.add(JaxbElementsFactory.createClassAnnotation(className));
        complexTypeElement.add(structurElement);
        return complexTypeElement;
    }
}

