/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.anwiba.commons.lang.io.NoneClosingInputStream;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;
import org.xml.sax.ContentHandler;

public class JaxbTransformer<T> {
    private final SAXTransformerFactory transformerFactory;
    private final JAXBContext jaxbContext;
    private final Templates inputTransformerTemplate;
    private final Templates outputTransformerTemplate;

    public JaxbTransformer(SAXTransformerFactory transformerFactory, Templates inputTransformerTemplate, Templates outputTransformerTemplate, JAXBContext jaxbContext) {
        this.transformerFactory = transformerFactory;
        this.inputTransformerTemplate = inputTransformerTemplate;
        this.outputTransformerTemplate = outputTransformerTemplate;
        this.jaxbContext = jaxbContext;
    }

    public void marshall(T bindingObject, IParameters parameters, OutputStream outputStream, IProperties outputProperties) throws JAXBException, TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        StreamResult outputResult = new StreamResult(byteArrayOutputStream);
        TransformerHandler handler = this.transformerFactory.newTransformerHandler(this.outputTransformerTemplate);
        handler.setResult(outputResult);
        Transformer transformer = handler.getTransformer();
        for (IProperty property : outputProperties.properties()) {
            transformer.setOutputProperty(property.getName(), property.getValue());
        }
        for (IParameter parameter : parameters.parameters()) {
            transformer.setParameter(parameter.getName(), parameter.getValue());
        }
        marshaller.marshal(bindingObject, (ContentHandler)handler);
        try {
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            outputStream.write(byteArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public T unmarshall(InputStream inputStream, IParameters parameters) throws JAXBException, TransformerException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
        Transformer transformer = this.inputTransformerTemplate.newTransformer();
        for (IParameter parameter : parameters.parameters()) {
            transformer.setParameter(parameter.getName(), parameter.getValue());
        }
        SAXResult saxResult = new SAXResult((ContentHandler)unmarshallerHandler);
        StreamSource streamSource = new StreamSource((InputStream)new NoneClosingInputStream(inputStream));
        transformer.transform(streamSource, saxResult);
        Object result = unmarshallerHandler.getResult();
        return (T)result;
    }
}

