/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.xsd;

import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class XsdElementsFactory {
    public static final String ANNOTATION = "annotation";
    public static final String APPINFO = "appinfo";
    public static final String BASE = "base";
    public static final String CHOICE = "choice";
    public static final String CLASS = "class";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String ELEMENT = "element";
    public static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";
    public static final String GENERATE_IS_SET_METHOD = "generateIsSetMethod";
    public static final String GLOBAL_BINDINGS = "globalBindings";
    public static final String MAX_OCCURS = "maxOccurs";
    public static final String MIN_OCCURS = "minOccurs";
    public static final String NAME = "name";
    public static final String PACKAGE = "package";
    public static final String QUALIFIED = "qualified";
    public static final String RESTRICTION = "restriction";
    public static final String SCHEMA_BINDINGS = "schemaBindings";
    public static final String SEQUENCE = "sequence";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String TRUE = "true";
    public static final String TYPE = "type";
    public static final String UNBOUNDED = "unbounded";
    public static final String VERSION = "version";
    public static final Namespace XSD_NAMESPACE = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final QName SCHEMA = new QName("schema", XSD_NAMESPACE);

    public static Element createSchemaElement() {
        Element element = DocumentHelper.createElement((QName)SCHEMA);
        element.addAttribute(XsdElementsFactory.createName(ELEMENT_FORM_DEFAULT), QUALIFIED);
        return element;
    }

    public static Element createElement(String name, String contentTypeName, int minimumOccurs, int maximumOccurs) {
        Element element = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(ELEMENT));
        element.addAttribute(XsdElementsFactory.createName(NAME), name);
        element.addAttribute(XsdElementsFactory.createName(TYPE), contentTypeName);
        element.addAttribute(XsdElementsFactory.createName(MIN_OCCURS), String.valueOf(minimumOccurs));
        element.addAttribute(XsdElementsFactory.createName(MAX_OCCURS), Integer.MAX_VALUE == maximumOccurs ? UNBOUNDED : String.valueOf(maximumOccurs));
        return element;
    }

    public static Element createSimpleTypeElement(String typeName, String baseTypeName) {
        Element restrictionElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(RESTRICTION));
        restrictionElement.addAttribute(XsdElementsFactory.createName(BASE), baseTypeName);
        Element simpleTypeElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(SIMPLE_TYPE));
        simpleTypeElement.addAttribute(XsdElementsFactory.createName(NAME), typeName);
        simpleTypeElement.add(restrictionElement);
        return simpleTypeElement;
    }

    public static Element createComplexTypeElement(String typeName, Element structurElement) {
        Element complexTypeElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(COMPLEX_TYPE));
        complexTypeElement.addAttribute(XsdElementsFactory.createName(NAME), typeName);
        complexTypeElement.add(structurElement);
        return complexTypeElement;
    }

    public static Element createSequenceElement(List<Element> elements) {
        Element sequenceElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(SEQUENCE));
        for (Element element : elements) {
            sequenceElement.add(element);
        }
        return sequenceElement;
    }

    public static Element createChoiceElement(List<Element> elements) {
        Element sequenceElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(CHOICE));
        for (Element element : elements) {
            sequenceElement.add(element);
        }
        return sequenceElement;
    }

    public static Element createApplicationInfoAnnotation(Element ... elements) {
        Element annotationElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(ANNOTATION));
        Element applicationInfoElement = DocumentHelper.createElement((QName)XsdElementsFactory.createXsdName(APPINFO));
        for (Element element : elements) {
            applicationInfoElement.add(element);
        }
        annotationElement.add(applicationInfoElement);
        return annotationElement;
    }

    public static QName createName(String name) {
        return new QName(name);
    }

    public static QName createXsdName(String name) {
        return new QName(name, XSD_NAMESPACE);
    }
}

