/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.text.MessageFormat;
import net.anwiba.commons.xml.dom.DomConverterException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;

public class DomToObjectConverterUtilities {
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";

    public static String getStringValue(Element element, String attributeName) throws DomConverterException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new DomConverterException(MessageFormat.format("Missing attribute {0} in element {1}", attributeName, element.getName()));
        }
        return attribute.getValue();
    }

    public static int getIntValue(Element element, String attributeName) throws DomConverterException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new DomConverterException(MessageFormat.format("Missing attribute {0} in element {1}", attributeName, element.getName()));
        }
        try {
            return Integer.parseInt(attribute.getValue());
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(MessageFormat.format("Number format exception in element {0} attribute {1} and value {2} ", element.getName(), attributeName, attribute.getValue()), exception);
        }
    }

    public static long getLongValue(Element element, String attributeName) throws DomConverterException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new DomConverterException(MessageFormat.format("Missing attribute {0} in element {1}", attributeName, element.getName()));
        }
        try {
            return Long.parseLong(attribute.getValue());
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(MessageFormat.format("Number format exception in element {0} attribute {1} and value {2} ", element.getName(), attributeName, attribute.getValue()), exception);
        }
    }

    public static boolean getBooleanValue(Element element, String attributeName) throws DomConverterException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new DomConverterException(MessageFormat.format("Missing attribute {0} in element {1}", attributeName, element.getName()));
        }
        String value = attribute.getValue();
        if (TRUE.equalsIgnoreCase(value)) {
            return true;
        }
        if (FALSE.equalsIgnoreCase(value)) {
            return false;
        }
        throw new DomConverterException(MessageFormat.format("Boolean format exception in element {0} attribute {1} and value {2} ", element.getName(), attributeName, value));
    }

    public static String getText(Element element, QName tagName) throws DomConverterException {
        Element textElement = element.element(tagName);
        if (textElement == null) {
            throw new DomConverterException(MessageFormat.format("Missing element {0}", element.getName()));
        }
        return textElement.getTextTrim();
    }

    public static String getOptionalText(Element element, QName tagName) {
        Element textElement = element.element(tagName);
        if (textElement == null) {
            return null;
        }
        return textElement.getTextTrim();
    }

    public static String getText(Element element, QName tagName, String defaultValue) {
        Element textElement = element.element(tagName);
        if (textElement == null) {
            return defaultValue;
        }
        return textElement.getTextTrim();
    }

    public static double getNecessaryDoubleValue(Element element) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("missing tag");
        }
        try {
            String text = element.getTextTrim();
            return Double.parseDouble(text);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(exception);
        }
    }

    public static double getDoubleValue(Element element, double defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        try {
            String text = element.getTextTrim();
            return Double.parseDouble(text);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(exception);
        }
    }

    public static int getNecessaryIntValue(Element element) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("missing tag");
        }
        try {
            String text = element.getTextTrim();
            return Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(exception);
        }
    }

    public static int getIntValue(Element element, int defaultValue) throws DomConverterException {
        if (element == null) {
            return defaultValue;
        }
        try {
            String text = element.getTextTrim();
            return Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            throw new DomConverterException(exception);
        }
    }

    public static Element getNecessaryElement(Element element, String tag) throws DomConverterException {
        if (element == null) {
            throw new DomConverterException("missing tag");
        }
        Element tagElement = element.element(tag);
        if (tagElement == null) {
            throw new DomConverterException(MessageFormat.format("missing tag: ''{0}''", tag));
        }
        return tagElement;
    }
}

