/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;
import net.anwiba.commons.xml.dom.DomConverterException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.Text;

public interface IObjectToDomConverter<T> {
    public Element convert(T var1) throws DomConverterException;

    default public Element element(QName name) {
        return DocumentHelper.createElement((QName)name);
    }

    default public Element element(String name) {
        return DocumentHelper.createElement((String)name);
    }

    default public Text text(String string) {
        return DocumentHelper.createText((String)string);
    }

    default public Element addTo(Element parent, Element child) {
        if (child == null) {
            return child;
        }
        parent.add(child);
        List namespaces = child.declaredNamespaces();
        if (child.getNamespace() != null) {
            parent.add(child.getNamespace());
        }
        for (Namespace namespace : namespaces) {
            parent.add(namespace);
        }
        return child;
    }

    default public String value(int value) {
        return String.valueOf(value);
    }

    default public String value(long value) {
        return String.valueOf(value);
    }

    default public String value(float value) {
        return String.valueOf(value);
    }

    default public String value(double value) {
        return String.valueOf(value);
    }

    default public String value(boolean value) {
        return String.valueOf(value);
    }

    default public String value(ZonedDateTime value) {
        return ZonedDateTimeUtilities.toString((ZonedDateTime)value);
    }

    default public String value(Duration value) {
        return value.toString();
    }
}

