/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.io;

import java.io.IOException;
import java.io.OutputStream;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.utilities.property.Properties;
import net.anwiba.commons.utilities.registry.AbstractApplicableRegistry;
import net.anwiba.commons.utilities.registry.IApplicableRegistry;
import net.anwiba.commons.xml.io.IConvertingXmlWriter;
import net.anwiba.commons.xml.io.IRegistableConvertingXmlWriter;

public class ConvertingXmlWriter<C>
implements IConvertingXmlWriter<C> {
    private final IApplicableRegistry<C, IRegistableConvertingXmlWriter<C, ?>> registry = new AbstractApplicableRegistry<C, IRegistableConvertingXmlWriter<C, ?>>(null){};
    private boolean isIndentEnabled = false;
    private boolean isOmitXMLDeclaration = false;

    public void enableXMLDeclaration() {
        this.isOmitXMLDeclaration = false;
    }

    public void disableXMLDeclaration() {
        this.isOmitXMLDeclaration = true;
    }

    public void enableIndent() {
        this.isIndentEnabled = true;
    }

    public void disableIndent() {
        this.isIndentEnabled = false;
    }

    public void add(IRegistableConvertingXmlWriter<C, ?> persister) {
        this.registry.add((IApplicable[])new IRegistableConvertingXmlWriter[]{persister});
    }

    @Override
    public <I> void write(C context, I object, IParameters parameters, OutputStream outputStream) throws IOException {
        IRegistableConvertingXmlWriter persister = (IRegistableConvertingXmlWriter)this.registry.get(context);
        if (persister == null) {
            throw new UnsupportedOperationException();
        }
        persister.write(object, parameters, outputStream, Properties.builder().put("indent", this.isIndentEnabled ? "yes" : "no").put("omit-xml-declaration", this.isOmitXMLDeclaration ? "yes" : "no").build());
    }
}

