/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xmpp;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.xmpp.MessageSender;
import net.anwiba.commons.xmpp.SecurityMode;
import org.jivesoftware.smack.ConnectionConfiguration;

public class MessageSenderBuilder {
    private final String host;
    private final String userName;
    private final String password;
    private boolean isSASLAuthenticationEnabled = false;
    private boolean isSendPresence = false;
    private SecurityMode securityMode = SecurityMode.ENABLE;
    private final List<String> saslAuthenticationTypes = new ArrayList<String>();
    private final List<String> receivers = new ArrayList<String>();
    private String serviceName;
    private int port = 5222;

    public MessageSenderBuilder(String host, String userName, String password) {
        this.host = host;
        this.userName = userName;
        this.password = password;
    }

    public MessageSender build() {
        ConnectionConfiguration configuration = new ConnectionConfiguration(this.host, this.port, this.serviceName == null ? this.host : this.serviceName);
        configuration.setSASLAuthenticationEnabled(this.isSASLAuthenticationEnabled);
        configuration.setSendPresence(this.isSendPresence);
        configuration.setSecurityMode(this.securityMode.getConfigurationValue());
        return new MessageSender(configuration, this.userName, this.password, this.saslAuthenticationTypes, this.receivers);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public MessageSenderBuilder setSASLAuthenticationEnabled(boolean isSASLAuthenticationEnabled) {
        this.isSASLAuthenticationEnabled = isSASLAuthenticationEnabled;
        return this;
    }

    public MessageSenderBuilder setSendPresence(boolean isSendPresence) {
        this.isSendPresence = isSendPresence;
        return this;
    }

    public MessageSenderBuilder setSecurityMode(SecurityMode isSecurityMode) {
        this.securityMode = isSecurityMode;
        return this;
    }

    public MessageSenderBuilder addReceiver(String receiver) {
        this.receivers.add(receiver);
        return this;
    }

    public MessageSenderBuilder addSASLAuthenticationType(String string) {
        this.saslAuthenticationTypes.add(string);
        return this;
    }
}

