/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xmpp.notification;

import java.util.List;
import net.anwiba.commons.message.notification.INotificationReceiver;
import net.anwiba.commons.message.notification.INotificationReceiverFactory;
import net.anwiba.commons.xmpp.MessageSenderBuilder;
import net.anwiba.commons.xmpp.SecurityMode;
import net.anwiba.commons.xmpp.notification.XMPPNotificationReceiver;

public class SimpleXMPPNotificationReceiverFactory
implements INotificationReceiverFactory {
    private final String host;
    private final String userName;
    private final String password;
    private final List<String> receivers;

    SimpleXMPPNotificationReceiverFactory(String host, String userName, String password, List<String> receivers) {
        this.host = host;
        this.userName = userName;
        this.password = password;
        this.receivers = receivers;
    }

    public INotificationReceiver create() {
        MessageSenderBuilder builder = new MessageSenderBuilder(this.host, this.userName, this.password);
        builder.setSASLAuthenticationEnabled(true).setSendPresence(false).setSecurityMode(SecurityMode.ENABLE);
        for (String receiver : this.receivers) {
            builder.addReceiver(receiver);
        }
        return new XMPPNotificationReceiver(builder.build());
    }
}

