/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xmpp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.notification.NotificationException;
import net.anwiba.commons.xmpp.DeafMessageListener;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class MessageSender {
    private static final ILogger logger = Logging.getLogger(MessageSender.class);
    private final ConnectionConfiguration configuration;
    private final String userName;
    private final String password;
    private final Iterable<String> saslAuthenticationTypes;
    private final Iterable<String> bodies;

    public MessageSender(ConnectionConfiguration configuration, String userName, String password, List<String> saslAuthenticationTypes, List<String> bodies) {
        this.configuration = configuration;
        this.userName = userName;
        this.password = password;
        this.bodies = bodies;
        this.saslAuthenticationTypes = Collections.unmodifiableList(saslAuthenticationTypes);
    }

    public void send(IMessage message) throws NotificationException {
        XMPPConnection connection = null;
        try {
            connection = this.createConnection();
            ChatManager chatManager = connection.getChatManager();
            for (String body : this.bodies) {
                this.send(chatManager, body, message);
            }
        }
        catch (XMPPException exception) {
            logger.log(ILevel.ERROR, exception.getMessage(), (Throwable)exception);
            throw new NotificationException("Coudn't send notification. " + this.toString(message), (Throwable)exception);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private XMPPConnection createConnection() throws XMPPException {
        for (String type : this.saslAuthenticationTypes) {
            SASLAuthentication.supportSASLMechanism((String)type, (int)0);
        }
        XMPPConnection connection = new XMPPConnection(this.configuration);
        connection.connect();
        connection.login(this.userName, this.password);
        return connection;
    }

    private void send(ChatManager chatManager, String body, IMessage message) throws XMPPException {
        Chat chat = chatManager.createChat(body, (MessageListener)new DeafMessageListener());
        chat.sendMessage(this.toString(message));
    }

    private String toString(IMessage message) {
        switch (message.getMessageType()) {
            case DEFAULT: {
                return message.getText();
            }
        }
        return message.getThrowable() == null ? MessageFormat.format("{0}: {1}", message.getMessageType().name(), message.getText()) : MessageFormat.format("{0}: {1} {2}", message.getMessageType().name(), message.getText(), this.toString(message.getThrowable()));
    }

    private Object toString(Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(outputStream));
        return outputStream.toString();
    }
}

