/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite.connection;

import net.anwiba.commons.version.IVersion;
import net.anwiba.database.sqlite.connection.ISqliteCapabilities;

public final class SqliteCapabilities
implements ISqliteCapabilities {
    private final IVersion sqliteVersion;
    private final IVersion spatiaLiteVersion;
    private final IVersion spatiaLiteDatabaseVersion;

    public SqliteCapabilities(IVersion sqliteVersion, IVersion spatiaLiteVersion, IVersion spatiaLiteDatabaseVersion) {
        this.sqliteVersion = sqliteVersion;
        this.spatiaLiteVersion = spatiaLiteVersion;
        this.spatiaLiteDatabaseVersion = spatiaLiteDatabaseVersion;
    }

    public IVersion getSqliteVersion() {
        return this.sqliteVersion;
    }

    public IVersion getSpatiaLiteVersion() {
        return this.spatiaLiteVersion;
    }

    public IVersion getSpatiaLiteDatabaseVersion() {
        return this.spatiaLiteDatabaseVersion;
    }

    @Override
    public boolean canChange() {
        if (this.spatiaLiteDatabaseVersion == null || this.spatiaLiteVersion == null) {
            return false;
        }
        if (this.spatiaLiteDatabaseVersion.getMajor() > 3 && this.spatiaLiteVersion.getMajor() > 3) {
            return true;
        }
        return this.spatiaLiteDatabaseVersion.getMajor() < 4 && this.spatiaLiteVersion.getMajor() < 4;
    }

    @Override
    public boolean isExtended() {
        return this.spatiaLiteVersion != null;
    }
}

