/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.database.sqlite;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.anwiba.commons.jdbc.metadata.IDataBaseType;
import net.anwiba.database.sqlite.ISqliteTypeVisitor;

public enum SqliteType implements IDataBaseType
{
    INT2(5, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitShort();
        }
    }
    ,
    INT4(4, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitInteger();
        }
    }
    ,
    INT8(-5, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitLong();
        }
    }
    ,
    INTEGER(-5, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitLong();
        }
    }
    ,
    BIGINT(-5, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitLong();
        }
    }
    ,
    FLOAT4(2, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitFloat();
        }
    }
    ,
    FLOAT8(8, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitDouble();
        }
    }
    ,
    DOUBLE_PRECISION(8, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitDouble();
        }
    }
    ,
    DECIMAL(3, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitDouble();
        }
    }
    ,
    NUMERIC(2, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitDouble();
        }
    }
    ,
    MONEY(8, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    BPCHAR(1, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    TEXT(12, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitVarchar();
        }
    }
    ,
    NAME(12, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    BYTEA(12, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    BOOL(-7, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitBoolean();
        }
    }
    ,
    TIME(92, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    TIMESTAMP(93, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    TIMETZ(92, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    TIMESTAMPTZ(93, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnsupportedType();
        }
    }
    ,
    UNKNOWN(Integer.MAX_VALUE, new String[0]){

        @Override
        public <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> visitor) throws E {
            visitor.visitUnknown();
        }
    };

    private final int code;
    private final Set<String> names = new HashSet<String>();

    private SqliteType(int code, String ... names) {
        this.code = code;
        this.names.addAll(Arrays.asList(names));
    }

    public static SqliteType getByName(String name) {
        String normalized = name.trim().replace(' ', '_').toUpperCase();
        SqliteType[] sqliteTypeArray = SqliteType.values();
        int n = sqliteTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqliteType type = sqliteTypeArray[n2];
            if (type.name().equals(normalized)) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static SqliteType getByTypeCode(int code) {
        SqliteType[] sqliteTypeArray = SqliteType.values();
        int n = sqliteTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqliteType type = sqliteTypeArray[n2];
            if (type.code == code) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public abstract <T, E extends Exception> void accept(ISqliteTypeVisitor<T, E> var1) throws E;

    /* synthetic */ SqliteType(String string, int n, int n2, String[] stringArray, SqliteType sqliteType) {
        this(n2, stringArray);
    }
}

